% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cal_cor_pleiotropic_h2_corrected_single.R
\name{Cal_cor_pleiotropic_h2_corrected_single}
\alias{Cal_cor_pleiotropic_h2_corrected_single}
\title{Compute single pleioh2g for target disease after correction with referred disease index in the rg matrix and corrected ratio}
\usage{
Cal_cor_pleiotropic_h2_corrected_single(
  rg_mat,
  h2g_T_single,
  corrected_weight_updated,
  plei_h2_idx
)
}
\arguments{
\item{rg_mat}{genetic correlation matrix.}

\item{h2g_T_single}{heritability for target diseases.}

\item{corrected_weight_updated}{the ratio for correction}

\item{plei_h2_idx}{index of the target disease in the rg_mat.}
}
\value{
pleioh2g value for the target disease after correction
}
\description{
This function computes pleioh2g for the target disease after correction.
}
\examples{

data(Results_full_rg)
data(h2_vector)
plei_h2_idx<-1
h2g_T_single <- h2_vector[plei_h2_idx]
corrected_weight_updated <- 0.78
Cal_cor_pleiotropic_h2_corrected_single(Results_full_rg,h2g_T_single,
corrected_weight_updated,plei_h2_idx)
}
