test_that("phymapnet_prepare_inputs aligns taxa", {
  skip_if_not_installed("ape")
  tree <- ape::read.tree(text = "(a:1,b:1,c:1);")
  otu <- matrix(1, nrow=3, ncol=2, dimnames=list(paste0("s",1:3), c("a","b")))
  prep <- phymapnet_prepare_inputs(otu, tree, prune = TRUE)
  expect_equal(colnames(prep$otu), rownames(prep$dist))
  expect_equal(colnames(prep$otu), prep$taxa)
})
