% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waveband.new.r
\name{waveband}
\alias{waveband}
\alias{new_waveband}
\title{Waveband constructor method}
\usage{
waveband(
  x = NULL,
  weight = NULL,
  SWF.e.fun = NULL,
  SWF.q.fun = NULL,
  norm = NULL,
  SWF.norm = NULL,
  hinges = NULL,
  wb.name = NULL,
  wb.label = wb.name
)

new_waveband(
  w.low,
  w.high,
  weight = NULL,
  SWF.e.fun = NULL,
  SWF.q.fun = NULL,
  norm = NULL,
  SWF.norm = NULL,
  hinges = NULL,
  wb.name = NULL,
  wb.label = wb.name
)
}
\arguments{
\item{x}{any R object on which applying the method \code{range()} yields an
vector of two numeric values, describing a range of wavelengths [\eqn{nm}].}

\item{weight}{a character string \code{"SWF"} or \code{"BSWF"}, use
\code{NULL} (the default) to indicate no weighting used when calculating
irradiance.}

\item{SWF.e.fun, SWF.q.fun}{a functions giving multipliers for a spectral
weighting function (energy and quantum, respectively) as a function of
wavelength [\eqn{nm}].}

\item{norm}{a single numeric value indicating the wavelength [\eqn{nm}] at
which the SWF should be normalized to 1.0; \code{NULL} is interpreted as no
normalization.}

\item{SWF.norm}{a numeric value giving the native normalization wavelength
[\eqn{nm}] used by \code{SWF.e.fun} and \code{SWF.q.fun}.}

\item{hinges}{a numeric vector giving the wavelengths at which values in
\code{s.irrad} should be inserted by interpolation before integration is
attempted. No interpolation is indicated by an empty vector
(\code{numeric(0)}), while interpolation at both boundaries of the band is
indicated by \code{NULL}.}

\item{wb.name}{character string giving the name for the waveband defined,
default is \code{NULL} for an automatically generated name.}

\item{wb.label}{character string giving the label of the waveband to be used
for labelling computed summaries or plots, default is \code{wb.name}. (This
is usually a shorter character string than \code{wb.name}.)}

\item{w.low, w.high}{numeric value, wavelengths at the short end and long ends
of the wavelength band [\eqn{nm}].}
}
\value{
a \code{waveband} object
}
\description{
Constructor for "waveband" objects that can be used as input when calculating
irradiances.
}
\details{
Objects of class \code{waveband} are used to store the different
  bits of information needed to compute summaries from spectral data by
  integration over wavelengths. The wavelength ranges, possible spectral
  weighting functions (SWF) or biological spectral weighting functions
  (BSWF), their normalization wavelengths and names and labels used for
  reporting the results are all stored in waveband objects. This facilitates
  the use of functions that compute summaries, as well as ensures consistency
  in computations and labelling, as all the bits of information are passed
  together. Class \code{"waveband"} is derived from R class \code{list}.
}
\section{Functions}{
\itemize{
\item \code{new_waveband()}: A less flexible variant

}}
\examples{
waveband(c(400,700))

new_waveband(400,700)

}
\seealso{
Other waveband constructors: 
\code{\link{split_bands}()}
}
\concept{waveband constructors}
