% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-psi-spectrapen-csv.r
\name{read_spectrapen_csv}
\alias{read_spectrapen_csv}
\title{Read '.CSV' File Saved by PSI's Software.}
\usage{
read_spectrapen_csv(
  file,
  start.row = 1,
  date = NULL,
  geocode = NULL,
  label = NULL,
  tz = NULL,
  locale = readr::default_locale()
)
}
\arguments{
\item{file}{character string.}

\item{start.row}{integer The first line to read, counting from the top of the
file.}

\item{date}{a \code{POSIXct} object to use to set the \code{"when.measured"}
attribute. If \code{NULL}, the default, the date is extracted from the file
header.}

\item{geocode}{A data frame with columns \code{lon} and \code{lat} used to
set attribute \code{"where.measured"}. If \code{NULL}, the default, the
location is extracted from the file header.}

\item{label}{character string, but if \code{NULL} the label from \code{file}
header is used, if the label is missing, the index is used, and if
\code{NA} the "what.measured" attribute is not set.}

\item{tz}{character Time zone used for interpreting times saved in the file
header.}

\item{locale}{The locale controls defaults that vary from place to place. The
default locale is US-centric (like R), but you can use
\code{\link[readr]{locale}} to create your own locale that controls things
like the default time zone, encoding, decimal mark, big mark, and day/month
names.}
}
\value{
A \code{source_mspct} object.
}
\description{
Reads and parses the header of a processed .CSV file as output by the by the
PSI (Photon Systems Instruments, Czech Republic) SpectraPen miniature
spectrometer.
}
\examples{
 # fetch path to example file to read
 file.name <-
   system.file("extdata", "spectrum-psi-spectrapen-SP.csv",
               package = "photobiologyInOut", mustWork = TRUE)

 spectrapen.mspct <- read_spectrapen_csv(file = file.name)

 spectrapen.mspct
 getWhenMeasured(spectrapen.mspct)
 getWhatMeasured(spectrapen.mspct)
 cat(comment(spectrapen.mspct))

}
\references{
\url{https://psi.cz/}
}
