% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapet_neuro.R
\docType{data}
\name{adapet_neuro}
\alias{adapet_neuro}
\title{Amyloid PET Scan Analysis Dataset}
\format{
A data frame with 49 columns:
\describe{
\item{ STUDYID }{Study Identifier}
\item{ USUBJID }{Unique Subject Identifier}
\item{ DOMAIN }{Domain Abbreviation}
\item{ ASEQ }{Analysis Sequence Number}
\item{ TRT01P }{Planned Treatment for Period 01}
\item{ TRT01A }{Actual Treatment for Period 01}
\item{ TRTSDT }{Date of First Exposure to Treatment}
\item{ TRTEDT }{Date of Last Exposure to Treatment}
\item{ ADT }{Analysis Date}
\item{ ADY }{Analysis Relative Day}
\item{ AVISIT }{Analysis Visit}
\item{ AVISITN }{Analysis Visit (N)}
\item{ PARAM }{Parameter}
\item{ PARAMCD }{Parameter Code}
\item{ AVAL }{Analysis Value}
\item{ AVALC }{Analysis Value (C)}
\item{ AVALU }{Analysis Value Unit}
\item{ BASE }{Baseline Value}
\item{ BASEC }{Baseline Value (C)}
\item{ BASETYPE }{Baseline Type}
\item{ CHG }{Change from Baseline}
\item{ PCHG }{Percent Change from Baseline}
\item{ CRIT1 }{Analysis Criterion 1}
\item{ CRIT1FL }{Criterion 1 Evaluation Result Flag}
\item{ ABLFL }{Baseline Record Flag}
\item{ ANL01FL }{Analysis Flag 01}
\item{ ANL02FL }{Analysis Flag 02}
\item{ ONTRTFL }{On Treatment Record Flag}
\item{ NVSEQ }{Sequence Number}
\item{ NVLNKID }{Link ID}
\item{ NVTESTCD }{Short Name of Nervous System Test}
\item{ NVTEST }{Name of Nervous System Test}
\item{ NVCAT }{Category for Nervous System Test}
\item{ NVLOC }{Location Used for the Measurement}
\item{ NVNAM }{Vendor Name}
\item{ NVORRES }{Result or Finding in Original Units}
\item{ NVORRESU }{Original Units}
\item{ NVSTRESC }{Character Result/Finding in Std Format}
\item{ NVSTRESN }{Numeric Result/Finding in Standard Units}
\item{ NVSTRESU }{Standard Units}
\item{ NVMETHOD }{Method of Test or Examination}
\item{ NVLOBXFL }{Last Observation Before Exposure Flag}
\item{ REFREG }{Reference Region}
\item{ AGTRT }{Reported Agent Name}
\item{ AGCAT }{Category for Agent}
\item{ VISITNUM }{Visit Number}
\item{ VISIT }{Visit Name}
\item{ NVDTC }{Date/Time of Collection}
\item{ NVDY }{Study Day of Visit/Collection/Exam}
}
}
\source{
Generated from admiralneuro package (template ad_adapet.R).
}
\usage{
adapet_neuro
}
\description{
Amyloid PET Scan Analysis Dataset
}
\details{
Contains a set of 7 unique Parameter Codes and Parameters: \tabular{ll}{
\strong{PARAMCD} \tab \strong{PARAM} \cr
CENTLD   \tab Centiloid value derived from SUVR pipeline                               \cr
SUVRAFBB \tab AVID FBB Standard Uptake Ratio Neocortical Composite Whole Cerebellum    \cr
SUVRAFBP \tab AVID FBP Standard Uptake Ratio Neocortical Composite Whole Cerebellum    \cr
SUVRBFBB \tab BERKELEY FBB Standard Uptake Ratio Neocortical Composite Whole Cerebellum\cr
SUVRBFBP \tab BERKELEY FBP Standard Uptake Ratio Neocortical Composite Whole Cerebellum\cr
VRFBB    \tab FBB Qualitative Visual Classification                                    \cr
VRFBP    \tab FBP Qualitative Visual Classification
}
}
\examples{
data("adapet_neuro")
}
\references{
None
}
\keyword{dataset}
\keyword{neurology}
