% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{getClusterDists}
\alias{getClusterDists}
\title{Compute cluster distance summaries}
\usage{
getClusterDists(dmat, groups, benchmarks)
}
\arguments{
\item{dmat}{distance matrix}

\item{groups}{groups resulting from clustering}

\item{benchmarks}{data frame with benchmark id and group number}
}
\value{
data frame with distance information
}
\description{
The returned tibble contains the id of the cluster pairs,
with benchmark distance (d1), minimum (d2) and maximum (d3) distances
between any points in the two clusters.
}
\examples{
dists <- getDists(Bikes$space1,"euclidean")
fit <- stats::hclust(dists, "ward.D2")
groups <- stats::cutree(fit, k = 4)
bm <- getBenchmarkInformation(as.matrix(dists), groups)
getClusterDists(as.matrix(dists), groups, bm)

}
