% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemini_batch_api.R
\name{run_gemini_batch_pipeline}
\alias{run_gemini_batch_pipeline}
\title{Run a Gemini batch pipeline for pairwise comparisons}
\usage{
run_gemini_batch_pipeline(
  pairs,
  model,
  trait_name,
  trait_description,
  prompt_template = set_prompt_template(),
  thinking_level = c("low", "medium", "high"),
  batch_input_path = tempfile(pattern = "gemini-batch-input-", fileext = ".json"),
  batch_output_path = tempfile(pattern = "gemini-batch-output-", fileext = ".jsonl"),
  poll = TRUE,
  interval_seconds = 60,
  timeout_seconds = 86400,
  api_key = Sys.getenv("GEMINI_API_KEY"),
  api_version = "v1beta",
  verbose = TRUE,
  include_thoughts = FALSE,
  ...
)
}
\arguments{
\item{pairs}{Tibble/data frame of pairs.}

\item{model}{Gemini model name, for example \code{"gemini-3-pro-preview"}.}

\item{trait_name}{Trait name.}

\item{trait_description}{Trait description.}

\item{prompt_template}{Prompt template string.}

\item{thinking_level}{One of \code{"low"}, \code{"medium"}, or \code{"high"}.}

\item{batch_input_path}{Path where the batch input JSON should be written.}

\item{batch_output_path}{Path where the batch output JSONL should be written
(only used if \code{poll = TRUE}).}

\item{poll}{Logical; if \code{TRUE}, poll the batch until completion and
parse results. If \code{FALSE}, only create the batch and write the input
file.}

\item{interval_seconds}{Polling interval when \code{poll = TRUE}.}

\item{timeout_seconds}{Maximum total waiting time when \code{poll = TRUE}.}

\item{api_key}{Optional Gemini API key.}

\item{api_version}{API version string.}

\item{verbose}{Logical; if \code{TRUE}, prints progress messages.}

\item{include_thoughts}{Logical; if \code{TRUE}, sets
\code{thinkingConfig.includeThoughts = TRUE} in each request, mirroring
\code{\link[=gemini_compare_pair_live]{gemini_compare_pair_live()}}. Parsed results will include a \code{thoughts}
column when visible thoughts are returned by the API (currently batch
typically only exposes \code{thoughtSignature} + \code{thoughtsTokenCount}).}

\item{...}{Additional arguments forwarded to
\code{\link{build_gemini_batch_requests}} (for example
\code{temperature}, \code{top_p}, \code{top_k},
\code{max_output_tokens}).}
}
\value{
A list with elements:
\describe{
\item{batch_input_path}{Path to the written batch input JSON.}
\item{batch_output_path}{Path to the batch output JSONL (or \code{NULL}
when \code{poll = FALSE}).}
\item{file}{Reserved for parity with OpenAI/Anthropic; always \code{NULL}
for Gemini inline batches.}
\item{batch}{The created Batch job object.}
\item{results}{Parsed tibble of results (or \code{NULL} when
\code{poll = FALSE}).}
}
}
\description{
This helper ties together the core batch operations:
\enumerate{
\item Build batch requests from a tibble of pairs.
\item Create a Batch job via \code{\link{gemini_create_batch}}.
\item Optionally poll for completion and download results.
\item Parse the JSONL results into a tibble via
\code{\link{parse_gemini_batch_output}}.
}
}
\details{
The returned list mirrors the structure of
\code{\link{run_openai_batch_pipeline}} and
\code{\link{run_anthropic_batch_pipeline}}.
}
\examples{
# This example requires:
# - A valid Gemini API key (set in GEMINI_API_KEY)
# - Internet access
# - Billable Gemini API usage
\dontrun{
# Example pairwise data
data("example_writing_samples", package = "pairwiseLLM")

pairs <- example_writing_samples |>
  make_pairs() |>
  sample_pairs(n_pairs = 5, seed = 123)

td <- trait_description("overall_quality")
tmpl <- set_prompt_template()

# Run the full Gemini batch pipeline
res <- run_gemini_batch_pipeline(
  pairs             = pairs,
  model             = "gemini-3-pro-preview",
  trait_name        = td$name,
  trait_description = td$description,
  prompt_template   = tmpl,
  thinking_level    = "low",
  poll              = TRUE,
  include_thoughts  = FALSE
)

# Parsed pairwise comparison results
res$results

# Inspect batch metadata
res$batch

# Paths to saved input/output files
res$batch_input_path
res$batch_output_path
}

}
