% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sharedTraitStudiesQuery.R
\name{sharedTraitStudiesQuery}
\alias{sharedTraitStudiesQuery}
\title{Retrieve Shared Trait Studies data for specified diseases.}
\usage{
sharedTraitStudiesQuery(diseaseIds, size = 500, index = 0)
}
\arguments{
\item{diseaseIds}{Character vector: IDs of the target diseases (e.g., c("EFO_0004587")).}

\item{size}{Integer: Number of records to retrieve (default: 500).}

\item{index}{Integer: Page index for pagination (default: 0).}
}
\value{
Returns a tibble containing shared trait studies data for the specified diseases.
}
\description{
This function queries the Open Targets GraphQL API to retrieve shared trait studies data
for specified disease IDs.
}
\examples{
\dontrun{
result <- sharedTraitStudiesQuery(diseaseIds = c("EFO_0004587"), size = 500, 
index = 0)
}
}
