% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locus2GeneQuery.R
\name{locus2GeneQuery}
\alias{locus2GeneQuery}
\title{Retrieve Locus-to-Gene Predictions data for a specified study locus.}
\usage{
locus2GeneQuery(studyLocusId)
}
\arguments{
\item{studyLocusId}{Character: ID of the target study locus (e.g., "fa375739ca2a6b825ce5cc69d117e84b").}
}
\value{
Returns a tibble containing locus-to-gene prediction data for the specified study locus.
}
\description{
This function queries the Open Targets GraphQL API to retrieve locus-to-gene prediction data
for a specified study locus.
}
\examples{
\dontrun{
result <- locus2GeneQuery(studyLocusId = "fa375739ca2a6b825ce5cc69d117e84b")
}
}
