test_that("von Eye main effects works", {
  n <- teachers
  x <- log_linear_main_effect_design(n)
  result <- log_linear_fit(n, x)
  expect_true(abs(23.79 - result$g_squared) <= 0.005)
}
)


test_that("von Eye equal weight agreement works", {
  n <- teachers
  x <- log_linear_equal_weight_agreement_design(n)
  result <- log_linear_fit(n, x)
  expect_true(abs(10.08 - result$g_squared) <= 0.005)
}
)


test_that("von Eye equal weight agreement works", {
  n <- depression
  w <- c(1, 2, 3)
  x <- log_linear_equal_weight_agreement_design(n)
  x <- von_Eye_weight_by_response_category_design(n, x=x, w=w)
  result <- log_linear_fit(n, x)
  expect_true(abs(13.49 - result$g_squared) <= 0.005)
  expect_equal(3, result$df)
}
)


test_that("von Eye continuous covariate example works", {
  n <- depression
  x <- log_linear_equal_weight_agreement_design(n)
  covariate <- c(17, 27, 3, 16, 45, 14, 1, 3, 3)
  x_prime <- log_linear_append_column(x, covariate)
  result <- log_linear_fit(n, x_prime)
  expect_true(abs(1.85 - result$g_squared) < 0.005)
  expect_equal(2, result$df)

  beta <- result$beta
  se <- result$se
  M <- length(beta)
  # NOTE: in book these are switched.
  expect_true(abs(3.65 - beta[M - 1]) <= 0.02, info=paste(3.65, beta[M - 1]))
  expect_true(abs(1.13 - se[M - 1]) <= 0.01, info=paste(1.13, se[M - 1]))
  expect_true(abs(-0.16 - beta[M]) <= 0.005, info=paste(-0.16, beta[M]))
  expect_true(abs(0.074 - se[M]) <= 0.0005, info=paste(0.074), se[M])
}
)


test_that("von Eye linear by linear works", {
  n <- radiology
  result <- von_Eye_linear_by_linear(n)
  expect_true(abs(8.84 - result$g_squared) <= 0.005,
              info=paste(8,84, result$g_squared))
  expect_equal(result$df, 8)
  expect_true(abs(2.060 - result$beta[length(result$beta)]) <= 0.0005,
              info=paste(0.356, result$beta[length(result$beta)]))
  expect_true(abs(0.356 - result$se[length(result$se)]) <= 0.0005,
              info=paste(0.356, result$se[length(result$se)]))
}
)


test_that("von Eye weight by response category works", {
  n <- depression
  w <- c(3, 2, 1, 1, 2, 3)
  x <- log_linear_equal_weight_agreement_design(tv)
  linear_linear <- log_linear_create_linear_by_linear(tv, TRUE)
  x_prime <- log_linear_append_column(x, linear_linear, ncol(x))
  x2 <- von_Eye_weight_by_response_category_design(n=tv, x=x_prime, w=w)
  result4 <- log_linear_fit(tv, x2)
  expect_true(abs(28.19 - result4$g_squared) <= 0.005)
  expect_equal(23, result4$df)
  beta <- result4$beta
  se <- result4$se
  M <- length(beta)
  expect_true(abs(0.209 - beta[M - 1]) <= 0.0005, info=paste(0.209, beta[M - 1]))
  expect_true(abs(0.068 - se[M - 1]) <= 0.0005, info=paste(0.068, se[M - 1]))
  expect_true(abs(0.209 - beta[M]) <= 0.0005)
  expect_true(abs(0.138 - se[M]) <= 0.0005)
}
)


test_that("von Eye equal weight diagonal linear works", {
  result3 <- von_Eye_equal_weight_diagonal_linear(tv, TRUE)
  expect_true(abs(28.72 - result3$g_squared) <= 0.005)
  expect_equal(23, result3$df)
  beta <- result3$beta
  se <- result3$se
  M <- length(beta)
  expect_true(abs(0.22 - beta[M]) <= 0.005)
  expect_true(abs(0.06 - se[M]) <= 0.005)
  expect_true(abs(0.34 - beta[M-1]) <= 0.005)
  expect_true(abs(0.25 - se[M-1]) <= 0.005)
}
)


test_that("von Eye diagonal linear works", {
  result <- von_Eye_diagonal_linear_by_linear(tv, TRUE)
  expect_true(abs(25.91 - result$g_squared) <= 0.005)
  expect_equal(result$df, 18)
  beta <- result$beta
  se <- result$se
  M <- length(beta)
  expect_true(abs(0.206 - beta[M]) <= 0.0005)
  expect_true(abs(0.071 - se[M]) <= 0.0005)
}
)

test_that("continuous covariate works", {
  n <- radiology
  covariate <- c(1.4, 2.0, 2.2, 0.0, 2.1,
                 2.2, 2.0, 0.0, 0.0, 2.2,
                 2.5, 0.0, 0.0, 2.2, 2.3,
                 1.7)
  x <- log_linear_equal_weight_agreement_design(radiology)
  w <- c(4.0, 1.0, 1.0, 4.0)
  x <- von_Eye_weight_by_response_category_design(radiology, x, w)
  result2 <- log_linear_fit(radiology, x)
  expect_true(abs(15.14 - result2$g_squared) <= 0.005)
  expect_equal(8, result2$df)
  linear_linear <- log_linear_create_linear_by_linear(radiology)
  x_prime <- log_linear_append_column(x, linear_linear)
  x_prime_prime <- log_linear_append_column(x_prime, covariate)
  result <- log_linear_fit(radiology, x_prime_prime)
  expect_true(abs(1.00 - result$g_squared) <= 0.005)
  expect_equal(6, result$df)
}
)

test_that("rater specific trends model is correct", {
    n <- paranoia
    x <- log_linear_main_effect_design(n)
    result <- log_linear_fit(paranoia, x)
    expect_true(abs(9.10 - result$g_squared) <= 0.005)
    expect_equal(result$df, 4)

    x <- log_linear_equal_weight_agreement_design(n)
    x_additional <- c(0, 1, 1, -1, 0, 1, -1, -1, 0)
    x_prime <- log_linear_append_column(x, x_additional)
    result2 <- log_linear_fit(n, x_prime)
    expect_true(abs(3.45 - result2$g_square) <= 0.01,
                info=paste(3.45, result2$g_square))
    expect_equal(result2$df, 2)
    beta <- result2$beta
    se <- result2$se
    M <- length(beta)
    expect_true(abs(0.37 - beta[M - 1]) <= 0.005)
    expect_true(abs(0.20 - se[M - 1]) <= 0.005)
    expect_true(abs(0.82 - beta[M]) <= 0.005)
    expect_true(abs(0.48 - se[M]) <= 0.01, info=paste(0.48, se[M]))
  }
)
