% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/API-Custom.R
\name{use_OpenMpp_custom}
\alias{use_OpenMpp_custom}
\title{OpenM++ Custom API Connection}
\usage{
use_OpenMpp_custom(req, ...)
}
\arguments{
\item{req}{A function that that performs any required user authentication
with the API and builds the initial part of the API request
including handling the authentication. Calling \code{req()} should return a
\code{httr2_request} object.}

\item{...}{Not currently used.}
}
\value{
Nothing, invisibly. Behind-the-scenes, an instance of the
\code{OpenMppCustom} R6 class is created. These objects should not be accessed
directly by the user, instead, the package internally uses these
connections to communicate with the OpenM++ OMS API.
}
\description{
Register a custom connection to the OpenM++ Web Services (OMS) Application
Programming Interface (API). A custom conneciton is typically comprised of
two main tasks: (1) authentication and (2) building the request. To create
your own custom connection, you simply need to create a function (\code{req})
that performs authentication (if needed) and builds the initial portion the
API request using the authentication information.
}
