% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/API-CPAC.R
\name{use_OpenMpp_CPAC}
\alias{use_OpenMpp_CPAC}
\title{OpenM++ CPAC API Connection}
\usage{
use_OpenMpp_CPAC(
  url = Sys.getenv("OPENMPP_CPAC_URL"),
  key = Sys.getenv("OPENMPP_CPAC_KEY"),
  ...
)
}
\arguments{
\item{url}{URL for making API requests. See \code{Details} for more
instructions.}

\item{key}{API Key for making requests.}

\item{...}{Not currently used.}
}
\value{
Nothing, invisibly. Behind-the-scenes, an instance of the
\code{OpenMppCPAC} R6 class is created. This objects should not be accessed
directly by the user, instead, the package internally uses these
connections to communicate with the OpenM++ API.
}
\description{
Register a connection to the OpenM++ Web Services (OMS) Application
Programming Interface (API) running on the CPAC cloud-based server.
}
\details{
An API key is sensitive information and should not be shared.
To avoid hard-coding your user name and password into your R scripts, we
recommend declaring this information in your global or project-specific
\code{.Renviron} file. The same approach may be used to declare
your URL for making API requests. While the URL us typically not
sensitive information, keeping all of this information in one place makes
sense for consistency. For remote API connections to CPAC, set the
following environment variables in your \code{.Renviron} files:
\itemize{
\item \code{OPENMPP_CPAC_URL}: URL for making remote API requests.
\item \code{OPENMPP_CPAC_KEY}: API key for making remote API requests.
}
}
\examples{
\dontrun{
use_OpenMpp_CPAC()
}

}
