% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oms-UpdateModelingTasks.R
\name{create_task}
\alias{create_task}
\alias{update_task}
\alias{delete_task}
\title{Update Modeling Tasks}
\usage{
create_task(data)

update_task(data)

delete_task(model, task)
}
\arguments{
\item{data}{Data used for the body of the request.}

\item{model}{Model digest or model name.}

\item{task}{Modeling task.}
}
\value{
A \code{list}, \code{tibble}, or nothing (invisibly).
}
\description{
Functions for updating modeling tasks. More information about these API
endpoints can be found at \href{https://github.com/openmpp/openmpp.github.io/wiki/Oms-web-service-API#update-modeling-tasks}{here}.
}
\examples{
\dontrun{
use_OpenMpp_local()
create_task(list(
  ModelName = "RiskPaths",
  ModelDigest = "d976aa2fb999f097468bb2ea098c4daf",
  Name = "NewTask",
  Set = list("Default")
))
delete_task("RiskPaths", "NewTask")
}

}
