% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oms-Administrative.R
\name{admin_models_refresh}
\alias{admin_models_refresh}
\alias{admin_models_close}
\alias{admin_database_close}
\alias{admin_model_delete}
\alias{admin_database_open}
\alias{admin_database_cleanup}
\alias{admin_cleanup_logs}
\alias{admin_cleanup_log}
\alias{admin_jobs_pause}
\alias{admin_jobs_pause_all}
\alias{admin_service_shutdown}
\title{OpenM++ Administrative Tasks}
\usage{
admin_models_refresh()

admin_models_close()

admin_database_close(model)

admin_model_delete(model)

admin_database_open(path)

admin_database_cleanup(path, name = NULL, digest = NULL)

admin_cleanup_logs()

admin_cleanup_log(name)

admin_jobs_pause(pause)

admin_jobs_pause_all(pause)

admin_service_shutdown()
}
\arguments{
\item{model}{Model digest or model name.}

\item{path}{Path to model database file relative to the \code{models/bin} folder.
For example, the name of the model with a \code{".sqlite"} extension.}

\item{name}{Model name. Optional for \code{admin_database_cleanup()}.}

\item{digest}{Model digest. Optional for \code{admin_database_cleanup()}.}

\item{pause}{Logical. Whether to pause or resume model runs queue processing.}
}
\value{
A \code{list} or nothing, invisibly.
}
\description{
Functions for performing administrative tasks. More information about the
administrative API endpoints can be found at \href{https://github.com/openmpp/openmpp.github.io/wiki/Oms-web-service-API#administrative-manage-web-service-state}{here}.
}
\details{
To find the relative \code{path} to a database file for cleanup with
\code{admin_database_cleanup(path)} or opening a database file with
\code{admin_database_open(path)}, users can run the \code{get_models_list()}
function to retrieve the list of model information and find the \code{DbPath}
list item. \code{DbPath} is the relative path to the database file. You
must replace the forward-slashes in the relative path with asterisks.
}
\examples{
\dontrun{
use_OpenMpp_local()
admin_models_refresh()
}


}
