% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user_defined_processes.R
\name{create_user_process}
\alias{create_user_process}
\title{Stores a graph as user defined process on the back-end}
\usage{
create_user_process(
  graph,
  id = NULL,
  summary = NULL,
  description = NULL,
  submit = TRUE,
  con = NULL,
  ...
)
}
\arguments{
\item{graph}{a process graph definition}

\item{id}{the title of the user process}

\item{summary}{the summary for the user process (optional)}

\item{description}{the description for the user process (optional)}

\item{submit}{whether to create a new user process at the openEO service or to create it for local use (default set to submit = TRUE)}

\item{con}{connected and authorized openEO client object (optional) otherwise \code{\link[=active_connection]{active_connection()}}
is used.}

\item{...}{additional parameters passed to jsonlite::toJSON() (like 'digits')}
}
\value{
a list assembling a process graph description or the graph id if send
}
\description{
Uploads the process graph information to the back-end and stores it. This can be used as a user defined process.
}
\details{
The parameter \code{submit} will be deprecated in the future. Please use \code{as(obj, "Process")}.
This function is useful when copying a JSON representation of your process graph to
another software. In that case use \code{udp = as(obj, "Process")} and simply print or call
object \code{udp} on the console.
}
