% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/client.R
\name{OMOPHubClient}
\alias{OMOPHubClient}
\title{OMOPHub API Client}
\value{
A new \code{OMOPHubClient} object.
}
\description{
R6 class for interacting with the OMOPHub vocabulary service.
Provides access to OHDSI ATHENA standardized medical vocabularies.
}
\details{
The client provides access to these resources:
\itemize{
\item \code{concepts}: Concept lookup and batch operations
\item \code{search}: Basic and advanced concept search
\item \code{vocabularies}: Vocabulary listing and details
\item \code{domains}: Domain listing and concept filtering
\item \code{hierarchy}: Ancestor and descendant navigation
\item \code{relationships}: Concept relationships
\item \code{mappings}: Concept mappings between vocabularies
}
}
\examples{
\dontrun{
# Create client (uses OMOPHUB_API_KEY env var)
client <- OMOPHubClient$new()

# Or with explicit API key
client <- OMOPHubClient$new(api_key = "your_api_key")

# Search for concepts
results <- client$search$basic("diabetes")

# Get a specific concept
concept <- client$concepts$get(201826)

# Use specific vocabulary version
client <- OMOPHubClient$new(vocab_version = "2025.1")
}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{concepts}}{Access to concept operations.}

\item{\code{search}}{Access to search operations.}

\item{\code{vocabularies}}{Access to vocabulary operations.}

\item{\code{domains}}{Access to domain operations.}

\item{\code{hierarchy}}{Access to hierarchy operations.}

\item{\code{relationships}}{Access to relationship operations.}

\item{\code{mappings}}{Access to mapping operations.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-OMOPHubClient-new}{\code{OMOPHubClient$new()}}
\item \href{#method-OMOPHubClient-print}{\code{OMOPHubClient$print()}}
\item \href{#method-OMOPHubClient-clone}{\code{OMOPHubClient$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OMOPHubClient-new"></a>}}
\if{latex}{\out{\hypertarget{method-OMOPHubClient-new}{}}}
\subsection{Method \code{new()}}{
Create a new OMOPHub client.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OMOPHubClient$new(
  api_key = NULL,
  base_url = NULL,
  timeout = 30,
  max_retries = 3,
  vocab_version = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{api_key}}{API key for authentication. If not provided, reads from
\code{OMOPHUB_API_KEY} environment variable or system keyring.}

\item{\code{base_url}}{API base URL. Defaults to \verb{https://api.omophub.com/v1}.}

\item{\code{timeout}}{Request timeout in seconds. Defaults to 30.}

\item{\code{max_retries}}{Maximum retry attempts for failed requests. Defaults to 3.}

\item{\code{vocab_version}}{Optional vocabulary version (e.g., "2025.1").
If not specified, uses the latest version.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OMOPHubClient-print"></a>}}
\if{latex}{\out{\hypertarget{method-OMOPHubClient-print}{}}}
\subsection{Method \code{print()}}{
Print client information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OMOPHubClient$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OMOPHubClient-clone"></a>}}
\if{latex}{\out{\hypertarget{method-OMOPHubClient-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OMOPHubClient$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
