# QUERY
#' @include AllGenerics.R
NULL

#' Build Query
#'
#' Initialize a query to the HAL API.
#' @param value A [`vector`] giving the topics to be searched for (see details).
#' @param field A [`character`] string specifying the field to search within.
#' @param ... Currently not used.
#' @return
#'  A [`list`] of class `HALQuery` containing at least the following components:
#'  \describe{
#'   \item{`q`}{(default to "`text:*`").}
#'   \item{`fl`}{default to "`docid,label_s`").}
#'   \item{`wt`}{(default to "`json`").}
#'  }
#' @example inst/examples/ex-query.R
#' @author N. Frerebeau
#' @family query tools
#' @export
hal_query <- function(value = "*", field = "text", ...) {
  term <- build_query(value)
  structure(
    list(
      q = sprintf("%s:%s", field, term),
      fl = "docid,label_s",
      wt = "json"
    ),
    class = "HALQuery"
  )
}
