% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveMedia.R
\name{saveMedia}
\alias{saveMedia}
\title{Uploads the given media for the given transcript}
\usage{
saveMedia(labbcat.url, id, media, track.suffix = NULL)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{id}{The transcript ID.}

\item{media}{The path to the media to upload.}

\item{track.suffix}{The track suffix for the media, if any.}
}
\value{
A named list describing the attributes of the uploaded media:
\itemize{
\item \emph{trackSuffix} The track suffix of the media
\item \emph{mimeType} The MIME type of the file
\item \emph{url} URL to the content of the file
\item \emph{name} Name of the file in LaBB-CAT
}
}
\description{
This function upload a media file to LaBB-CAT, associating it with a given transcript.
}
\details{
For this function to work, the credentials used to connect to the server must have at
least 'edit' access.
}
\examples{
\dontrun{

## upload transcript
saveMedia(
    labbcat.url, "my-transcript.eaf", "my-transcript/audio/room-mic.wav", "-room")
}
}
\seealso{
\itemize{
\item \link{getAvailableMedia}
\item \link{deleteMedia}
}
}
\keyword{media}
\keyword{upload}
