% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nyc_locallaw18_payreport.R
\name{nyc_locallaw18_payreport}
\alias{nyc_locallaw18_payreport}
\title{Local Law 18 Pay and Demographics Report - Agency Report Table}
\source{
NYC Open Data: <https://data.cityofnewyork.us/City-Government/Local-Law-18-Pay-and-Demographics-Report-Agency-Re/423i-ukqr/about_data>
}
\usage{
nyc_locallaw18_payreport(limit = 10000, filters = list(), timeout_sec = 30)
}
\arguments{
\item{limit}{Number of rows to retrieve (default = 10,000).}

\item{filters}{Optional list of field-value pairs to filter results.}

\item{timeout_sec}{Request timeout in seconds (default = 30).}
}
\value{
A tibble containing Local Law 18 Pay and Demographics Report - Agency Report Table data.
}
\description{
Downloads Local Law 18 Pay and Demographics Report - Agency Report Table data from NYC Open Data.
}
\details{
In accordance with Local Law 18 0f 2019, this dataset displays pay and workforce demographics
of various city agencies. This dataset is useful for researchers wishing to explore
ethnicity, salary, and gender within city agencies. Each row represents a group of employees
with a common agency, EEO-4 Job Category, pay band, employee status and demographic attributes,
which include race, ethnicity and gender.
}
\examples{
# Examples that hit the live NYC Open Data API are guarded so CRAN checks
# do not fail when the network is unavailable or slow.
if (interactive() && curl::has_internet()) {
  # Quick example (fetch 2 rows)
  small_sample <- nyc_locallaw18_payreport(limit = 2)
  small_sample

  nyc_locallaw18_payreport(limit = 2, filters = list(race = "White"))
}
}
