% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nyc_street_hail_livery_active.R
\name{nyc_street_hail_livery_active}
\alias{nyc_street_hail_livery_active}
\title{Street Hail Livery (SHL) Drivers - Active}
\source{
NYC Open Data: <https://data.cityofnewyork.us/Transportation/Street-Hail-Livery-SHL-Drivers-Active/5tub-eh45/about_data>
}
\usage{
nyc_street_hail_livery_active(
  limit = 10000,
  filters = list(),
  timeout_sec = 30
)
}
\arguments{
\item{limit}{Number of rows to retrieve (default = 10,000).}

\item{filters}{Optional list of field-value pairs to filter results.}

\item{timeout_sec}{Request timeout in seconds (default = 30).}
}
\value{
A tibble containing Street Hail Livery (SHL) Drivers - Active data.
}
\description{
Downloads Street Hail Livery (SHL) Drivers - Active data from NYC Open Data.
}
\details{
NYC TLC licensed drivers that are currently active, in good standing and authorized to operate Street Hail Livery (SHL) vehicles.
This list is accurate to the date and time represented in the Last Date Updated and Last Time Updated fields.
}
\examples{
# Examples that hit the live NYC Open Data API are wrapped so CRAN checks
# do not fail when the network is unavailable or slow.
\donttest{
if (curl::has_internet()) {
  # Quick example (fetch 2 rows)
  small_sample <- nyc_street_hail_livery_active(limit = 2)
  small_sample

  nyc_street_hail_livery_active(filters = list(status_description = "SHL UNRESTRICTED"))
}
}
}
