% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_tests.R
\name{shapiro_bootstrap.test}
\alias{shapiro_bootstrap.test}
\title{The Sieve Bootstrap Shapiro test for normality.}
\usage{
shapiro_bootstrap.test(y, reps = 1000, h = 100, seed = NULL)
}
\arguments{
\item{y}{a numeric vector or an object of the \code{ts} class containing a
stationary time series.}

\item{reps}{an integer with the total bootstrap repetitions.}

\item{h}{an integer with the first \code{burn-in} sieve bootstrap replicates.}

\item{seed}{An optional \code{\link[=set.seed]{seed}} to use.}
}
\value{
A list with class \code{"h.test"} containing the following components:
 \item{statistic:}{the sieve bootstrap Shapiro's statistic.}
 \item{p.value:}{the p value for the test.}
 \item{alternative:}{a character string describing the alternative hypothesis.}
 \item{method:}{a character string \dQuote{Sieve-Bootstrap Shapiro's test}.}
 \item{data.name:}{a character string giving the name of the data.}
}
\description{
Performs the approximated Shapiro test for normality for univariate time series.
Computes the p-value using Psaradakis and Vavra's (2020) sieve bootstrap procedure.
}
\details{
Employs the Shapiro test approximating the p-value using
a sieve-bootstrap procedure, \emph{Psaradakis, Z. and Vávra, M. (2020)}.
}
\examples{
# Generating an stationary arma process
y = arima.sim(100,model = list(ar = 0.3))
jb_bootstrap.test(y)

}
\references{
Psaradakis, Z. and Vávra, M. (2020) Normality tests for dependent
data: large-sample and bootstrap approaches. Communications in
\emph{Statistics-Simulation and Computation 49 (2)}. ISSN 0361-0918.

Bulmann, P. (1997). Sieve Bootstrap for time series. \emph{Bernoulli}.
3(2), 123 -148.

Patrick Royston (1982). An extension of Shapiro and Wilk's W test for
normality to large samples. \emph{Applied Statistics}, 31, 115–124.
Doi:10.2307/2347973.
}
\seealso{
\code{\link{vavra.test}}, \code{\link{sieve.bootstrap}}
}
\author{
Asael Alonzo Matamoros.
}
