% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shape_comp_plot.R
\name{shape_comp_plot}
\alias{shape_comp_plot}
\title{Compare Observed Nominal Distribution with Theoretical Shapes}
\usage{
shape_comp_plot(df, var, rate_exp = 0.7, scale = c("count", "percent"))
}
\arguments{
\item{df}{A data.frame or tibble containing the nominal variable.}

\item{var}{Character string giving the name of the nominal variable in \code{df}.}

\item{rate_exp}{Numeric. Rate parameter for the exponential distribution (Pareto-like). Default is 0.7.}

\item{scale}{Character. Whether to scale frequencies as counts ("count") or percentages ("percent"). Default is "count".}
}
\value{
A ggplot2 object.
}
\description{
Plots a centered dotplot of a nominal variable and overlays four
theoretical distributions: uniform, triangular, exponential (Pareto-like),
and normal-like.
}
\details{
The function orders categories from most frequent at the center outwards.
Observed frequencies are plotted as points and lines, and each theoretical
distribution is overlaid with a different color and line type.
}
\examples{
shape_comp_plot(categories, "animal")
shape_comp_plot(categories2, "animal")
shape_comp_plot(categories3, "animal")

}
