% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_screening.R
\name{tmvn_check_converge}
\alias{tmvn_check_converge}
\title{Check the convergence of 1st moment with m at selected indices of a TMVN distribution}
\usage{
tmvn_check_converge(
  cens_lb,
  cens_ub,
  covmat = NULL,
  locs = NULL,
  cov_name = NULL,
  cov_parm = NULL,
  m_vec = seq(from = 10, to = 100, by = 10),
  N = 1000,
  ind_test = NULL
)
}
\arguments{
\item{cens_lb}{lower bound vector for TMVN of length n}

\item{cens_ub}{upper bound vector for TMVN of length n}

\item{covmat}{n-by-n dense covariance matrix, either \code{covmat} or \code{locs},
\code{cov_name}, and \code{cov_parm} need to be provided}

\item{locs}{location matrix n X d}

\item{cov_name}{covariance function name from the \code{GpGp} package}

\item{cov_parm}{parameters for the covariance function from the \code{GpGp} package}

\item{m_vec}{a vector of \code{m} values (int) to be tested}

\item{N}{the number of samples to generate for each test index and each \code{m} to evaluate 1st-order moment}

\item{ind_test}{a vector of indices indexing the locs where we check the 1st-order moment convergence, by default, 10 random indices are used}
}
\value{
a matrix summarizing the 1st moments evaluated at increasing m at the selected indices
}
\description{
Check the convergence of 1st moment with m at selected indices of a TMVN distribution
}
\examples{
library(GpGp)
library(nntmvn)
library(lhs)
library(ggplot2)
set.seed(123)
n <- 500
locs <- lhs::randomLHS(n, 2)
lb <- rep(-Inf, n)
ub <- rep(0, n)

# using covariance matrix
covmat <- GpGp::matern15_isotropic(c(1, 0.1, 0.001), locs)
first_mmt <- tmvn_check_converge(lb, ub, covmat,
  m_vec = seq(from = 10, to = 50, by = 10)
)
plot(first_mmt)

# using locs, cov_name, and cov_parm
cov_name <- "matern15_isotropic"
cov_parm <- c(1, 0.1, 0.001)
first_mmt <- tmvn_check_converge(lb, ub,
  locs = locs, cov_name = cov_name, cov_parm = cov_parm,
  m_vec = seq(from = 10, to = 50, by = 10)
)
plot(first_mmt) + theme(text = element_text(size = 14))

}
