% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aqrVPC.R
\name{aqrVPC}
\alias{aqrVPC}
\title{The visual predictive checks using the additive quantile regression (aqrVPC)}
\usage{
aqrVPC(orig_data, 
       sim_data, 
       probs = c(0.1,0.5,0.9),
       conf.level = 0.95, 
       X_name = "TIME", 
       Y_name = "DV",
       MissingDV = NULL, 
       plot_caption = TRUE,
       DV_point = TRUE,
       plot_flag = TRUE,
       linesize = 0.7, 
       pointsize = 0.7, 
       captionsize = 10,
       qss_lambda = NULL, ...)
}
\arguments{
\item{orig_data}{A data frame of original data with X and Y variable.}

\item{sim_data}{A matrix of simulated data with only Y values collected.}

\item{probs}{A numeric vector of probabilities.}

\item{conf.level}{Confidence level of the interval.}

\item{X_name}{Name of X variable in orig_data (usually "TIME" in pharmacokinetic data).}

\item{Y_name}{Name of Y variable in orig_data (usually "DV" in pharmacokinetic data).}

\item{MissingDV}{Name of missing indicator variable in orig_data, which have value 1 if missing, value 0 otherwise. (usually "MDV" in pharmacokinetic data).}

\item{plot_caption}{Put caption with additional information if TRUE; omit if FALSE.}

\item{DV_point}{Draw point (X, Y) in the plot if TRUE; omit if FALSE.}

\item{plot_flag}{Draw plot if TRUE; generate data for drawing plot if FALSE.}

\item{linesize}{Size of line in the plot.}

\item{pointsize}{Size of point in the plot.}

\item{captionsize}{Size of caption.}

\item{qss_lambda}{Smoothing parameter in quantreg::qss function. 
Larger lambda produces a smoother fit.}

\item{...}{Arguments to be passed to methods.}
}
\value{
aqrVPC plot or the values to draw aqrVPC plot.
}
\description{
This function draws the visual predictive check (VPC) plot 
using additive quantile regression. The quantile 
regression methods are used to calculate quantiles.
}
\examples{
data(origdata)
data(simdata)
#aqrVPC(origdata,simdata)
}
\references{
Koenker, Roger, and Kevin F. Hallock. "Quantile regression." 
            Journal of economic perspectives 15.4 (2001): 143-156.

Jamsen, K. M., Patel, K., Nieforth, K., & Kirkpatrick, C. M. 
            (2018). A regression approach to visual predictive checks for
             population pharmacometric models. CPT: pharmacometrics & 
             systems pharmacology, 7(10), 678-686.
}
