% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{parse_rules_cpp}
\alias{parse_rules_cpp}
\title{Low-level C++ parser for association rules}
\usage{
parse_rules_cpp(rules_df)
}
\arguments{
\item{rules_df}{A data frame with the \strong{required} columns:
\itemize{
  \item \code{Antecedent} (\code{character})
  \item \code{Consequence} (\code{character})
  \item \code{Support} (\code{numeric})
  \item \code{Confidence} (\code{numeric})
  \item \code{Fitness} (\code{numeric}; treated as \emph{lift} by convention)
}}
}
\value{
A \code{list} with two data frames:
\describe{
  \item{\code{items}}{
    Columns:
    \itemize{
      \item \code{item_id}: integer, \strong{0-based} stable ID within this parsed object.
      \item \code{label}: original item string.
      \item \code{feature}: base feature name.
      \item \code{kind}: one of \code{"numeric"}, \code{"categorical"}, \code{"set"}, \code{"unknown"}.
      \item \code{category_value}: categorical value (quotes removed).
      \item \code{lo}, \code{hi}: numeric bounds (may be \code{NA}).
      \item \code{incl_low}, \code{incl_high}: logical inclusivity flags.
      \item \code{op}: one of \code{"<"}, \code{"<="}, \code{">"}, \code{">="}, \code{"="}, \code{"in"}.
      \item \code{label_long}, \code{label_short}: preformatted interval labels.
    }
  }
  \item{\code{rules}}{
    Columns:
    \itemize{
      \item \code{rule_id}: 1-based rule index (for display).
      \item \code{support}, \code{confidence}, \code{lift}: rule-level metrics.
      \item \code{lhs_item_ids}, \code{rhs_item_ids}: list-columns of integer vectors
            of 0-based \code{item_id}s.
      \item \code{antecedent_length}, \code{consequent_length}: integer lengths of LHS/RHS.
    }
  }
}
}
\description{
`parse_rules_cpp()` is the Rcpp-exposed engine behind \code{\link{parse_rules}}.
It accepts a data frame of association rules and returns a layout-agnostic
parsed structure consisting of an \emph{items} table and a \emph{rules} table.
This function is exported by Rcpp primarily for internal use and testing.
}
\details{
\strong{Parsing rules}
\itemize{
  \item Both LHS and RHS are split on \code{","} or \code{"&"} \emph{outside} of
        brackets; leading/trailing whitespace is trimmed.
  \item A single outer brace pair \code{\{...\}} on RHS is stripped if present.
  \item Supported item syntaxes:
        \itemize{
          \item Categorical equality: \code{feature = value} (value may be quoted).
          \item Numeric interval: \code{feature in [lo, hi]}, \code{(lo, hi]}, etc.
          \item Relational: \code{feature >= x}, \code{> x}, \code{<= x}, \code{< x}.
        }
  \item For relational items, the unused bound is set to \code{NA}.
  \item \code{Fitness} is carried through as \code{lift}.
}
}
\section{Errors}{

Throws an error if required columns are missing or have inconsistent lengths.
}

\keyword{internal}
