% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Goalie.R
\name{goalie_leaders}
\alias{goalie_leaders}
\title{Access the goalie statistics leaders for a season, game type, and category}
\usage{
goalie_leaders(season = "current", game_type = "", category = "wins")
}
\arguments{
\item{season}{integer in YYYYYYYY (e.g., 20242025); see \code{\link[=seasons]{seasons()}} for
reference}

\item{game_type}{integer in 1:3 (where 1 = pre-season, 2 = regular season, 3
= playoff/post-season) OR character of 'pre', 'regular', or
playoff'/'post'; see \code{\link[=seasons]{seasons()}} for reference; most functions will NOT
support pre-season}

\item{category}{character of 'w'/'wins', 's'/shutouts',
's\%'/'sP'/'save \%'/'save percentage', or 'gaa'/'goals against average'}
}
\value{
data.frame with one row per player
}
\description{
\code{goalie_leaders()} retrieves the goalie statistics leaders for a season, game type, and category as a \code{data.frame} where each row represents player and includes detail on player identity, role, handedness, and biographical profile.
}
\examples{
GAA_leaders_regular_20242025 <- goalie_leaders(
  season    = 20242025,
  game_type = 2,
  category  = 'GAA'
)
}
