% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model.R
\name{calculate_expected_goals}
\alias{calculate_expected_goals}
\alias{calculate_xG}
\title{Calculate the expected goals for all the shots in (a) play-by-plays}
\usage{
calculate_expected_goals(play_by_play, model = 1)

calculate_xG(play_by_play, model = 1)
}
\arguments{
\item{play_by_play}{data.frame of play-by-play(s); see \code{\link[=gc_play_by_play]{gc_play_by_play()}}, \code{\link[=gc_play_by_plays]{gc_play_by_plays()}}, \code{\link[=wsc_play_by_play]{wsc_play_by_play()}}, or \code{\link[=wsc_play_by_plays]{wsc_play_by_plays()}} for reference; the original columns must exist}

\item{model}{integer in 1:4 indicating which expected goals model to use; see web documentation for what variables each model considers}
}
\value{
data.frame with one row per event (play) and added \code{xG} column
}
\description{
\code{calculate_expected_goals()} calculates the expected goals for all the shots in (a) play-by-play(s) using the provided \code{model}.
}
\examples{
# May take >5s, so skip.
\donttest{
  pbp <- gc_play_by_play()
  pbp_with_xG_v3 <- calculate_expected_goals(play_by_play = pbp, model = 3)
}
}
