% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surface-graph.R
\name{get_surface_distance}
\alias{get_surface_distance}
\title{Compute geodesic distances on a surface mesh}
\usage{
get_surface_distance(vertices, faces, source_vertices = NULL)
}
\arguments{
\item{vertices}{Numeric matrix (n x 3) of vertex coordinates.}

\item{faces}{Integer matrix (m x 3) of face indices (1-indexed).}

\item{source_vertices}{Optional integer vector of source vertex indices.
If \code{NULL}, computes the full n x n distance matrix.}
}
\value{
Numeric distance matrix. If \code{source_vertices} is provided, returns
a \verb{length(source_vertices) x n} matrix; otherwise an \verb{n x n} matrix.
}
\description{
Builds a graph from a triangular mesh and computes shortest-path (Dijkstra)
distances between vertices.
}
\examples{
vertices <- matrix(
  c(0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1),
  nrow = 4, byrow = TRUE
)
faces <- matrix(c(1L, 2L, 3L, 2L, 3L, 4L), nrow = 2, byrow = TRUE)
get_surface_distance(vertices, faces)
}
\references{
Markello RD et al. (2022) Nature Methods 19:1472-1480.
doi:10.1038/s41592-022-01625-w
}
