% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image-utils.R
\name{annot_to_gifti}
\alias{annot_to_gifti}
\title{Convert FreeSurfer annotation to GIFTI}
\usage{
annot_to_gifti(annot_path, output_path = NULL)
}
\arguments{
\item{annot_path}{Path to FreeSurfer \code{.annot} file.}

\item{output_path}{Output GIFTI path. If \code{NULL}, replaces the extension
with \code{.label.gii}.}
}
\value{
The output file path (invisibly).
}
\description{
Reads a FreeSurfer \code{.annot} file and writes a GIFTI label file.
}
\examples{
\dontrun{
annot_to_gifti("lh.aparc.annot")
annot_to_gifti("lh.aparc.annot", "lh.aparc.label.gii")
}
}
\references{
Markello RD et al. (2022) Nature Methods 19:1472-1480.
doi:10.1038/s41592-022-01625-w
}
