% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server.R
\name{handler}
\alias{handler}
\title{Create HTTP Handler}
\usage{
handler(path, callback, method = "GET", prefix = FALSE)
}
\arguments{
\item{path}{URI path to match (e.g., "/api/data", "/users").}

\item{callback}{Function to handle requests. Receives a list with:
\itemize{
\item \code{method} - HTTP method (character)
\item \code{uri} - Request URI (character)
\item \code{headers} - Named character vector of headers
\item \code{body} - Request body (raw vector)
}

Should return a list with:
\itemize{
\item \code{status} - HTTP status code (integer, default 200)
\item \code{headers} - Response headers as a named character vector, e.g.
\code{c("Content-Type" = "application/json")} (optional)
\item \code{body} - Response body (character or raw)
}}

\item{method}{[default "GET"] HTTP method to match (e.g., "GET", "POST",
"PUT", "DELETE"). Use \code{"*"} to match any method.}

\item{prefix}{[default FALSE] Logical, if TRUE matches path as a prefix
(e.g., "/api" will match "/api/users", "/api/items", etc.).}
}
\value{
A handler object for use with \code{\link[=http_server]{http_server()}}.
}
\description{
Creates an HTTP route handler for use with \code{\link[=http_server]{http_server()}}.
}
\details{
If the callback throws an error, a 500 Internal Server Error
response is returned to the client.
}
\examples{
# Simple GET handler
h1 <- handler("/hello", function(req) {
  list(status = 200L, body = "Hello!")
})

# POST handler that echoes the request body
h2 <- handler("/echo", function(req) {
  list(status = 200L, body = req$body)
}, method = "POST")

# Catch-all handler for a path prefix
h3 <- handler("/static", function(req) {
  # Serve static files under /static/*
}, method = "*", prefix = TRUE)

}
\seealso{
\code{\link[=handler_ws]{handler_ws()}} for WebSocket handlers. Static handlers:
\code{\link[=handler_file]{handler_file()}}, \code{\link[=handler_directory]{handler_directory()}}, \code{\link[=handler_inline]{handler_inline()}},
\code{\link[=handler_redirect]{handler_redirect()}}.
}
