% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_signature_multiple.R
\name{plot_signature_multiple}
\alias{plot_signature_multiple}
\title{Plot Multiple Transcriptomic Signatures}
\usage{
plot_signature_multiple(
  phyex_sets,
  legend_title = "Phylo Expression Set",
  show_p_val = TRUE,
  conservation_test = stat_flatline_test,
  transformation = NULL,
  colours = NULL,
  ...
)
}
\arguments{
\item{phyex_sets}{A vector of PhyloExpressionSet objects to compare (BulkPhyloExpressionSet or ScPhyloExpressionSet)}

\item{legend_title}{Title for the legend (default: "Phylo Expression Set")}

\item{show_p_val}{Logical indicating whether to show p-values (default: TRUE)}

\item{conservation_test}{Function to use for conservation testing (default: stat_flatline_test)}

\item{transformation}{Optional transformation function to apply to all datasets (default: NULL)}

\item{colours}{Optional vector of colors for each dataset (default: NULL)}

\item{...}{Additional arguments passed to plot_signature}
}
\value{
A ggplot2 object showing multiple transcriptomic signatures
}
\description{
Create a plot comparing multiple transcriptomic signatures on the same axes,
with options for statistical testing and transformations.
}
\details{
This function allows comparison of multiple transcriptomic signatures by overlaying
them on the same plot. Each signature is colored differently and can be tested
for conservation patterns (bulk data only). If a transformation is provided, it's applied to all
datasets before plotting.

The function automatically adapts to the data type:
- **Bulk data**: Line plots with optional statistical testing
- **Single-cell data**: Violin plots showing distributions

All datasets must use the same axis labels (developmental stages or cell types).
}
\examples{
# Compare multiple bulk datasets
phyex_set <- example_phyex_set

bulk_list <- c(phyex_set, 
  phyex_set |> remove_genes(phyex_set@gene_ids[1:5]))
p <- plot_signature_multiple(bulk_list, legend_title = "Dataset")



}
