% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_from_signvector.R
\name{set_from_signvector}
\alias{set_from_signvector}
\title{Create a scale from a sign vector}
\usage{
set_from_signvector(
  signvec,
  card,
  nmax = 12,
  reconvert = FALSE,
  ineqmat = NULL,
  target_edo = NULL,
  edo = 12,
  rounder = 10
)
}
\arguments{
\item{signvec}{Vector of \code{0}, \code{-1}, and \code{1}s: the sign vector that
you want to realize.}

\item{card}{Integer: the number of notes in your desired scale.}

\item{nmax}{Integer, essentially a limit to how far the function should search before giving up.
Although every real color should have a rational representation in some mod k universe, for some colors
that k must be very high. Increasing nmax makes the function run longer but might be necessary
if small chromatic universes don't produce a result. Defaults to \code{12}.}

\item{reconvert}{Boolean. Should the scale be converted to the input edo? Defaults to \code{FALSE}.}

\item{ineqmat}{Specifies which hyperplane arrangement to consider. By default (or by
explicitly entering "mct") it supplies the standard "Modal Color Theory" arrangements
of \code{\link[=getineqmat]{getineqmat()}}, but can be set to "white," "black", "gray", "roth", "pastel," or "rosy",
giving the \code{ineqmat}s of \code{\link[=make_white_ineqmat]{make_white_ineqmat()}}, \code{\link[=make_black_ineqmat]{make_black_ineqmat()}}, \code{\link[=make_gray_ineqmat]{make_gray_ineqmat()}},
\code{\link[=make_roth_ineqmat]{make_roth_ineqmat()}}, \code{\link[=make_pastel_ineqmat]{make_pastel_ineqmat()}}, and \code{\link[=make_rosy_ineqmat]{make_rosy_ineqmat()}}. For other
arrangements, the desired inequality matrix can be entered directly.}

\item{target_edo}{Numeric (expected integer) determining a specific equal division of the octave to
quantize to. Defaults to \code{NULL}, in which any potential \code{edo} will be accepted.}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}

\item{rounder}{Numeric (expected integer), defaults to \code{10}:
number of decimal places to round to when testing for equality.}
}
\value{
If \code{reconvert=FALSE}, a list of two elements: element 1 is \code{set} with a vector of integers
representing the realized scale; element 2 is \code{edo} representing the number k of unit steps in the
mod k universe. If \code{reconvert=TRUE}, returns a single numeric vector converted to measurement relative
to 12-tone equal tempered semitones. Values may be \code{NA} if no suitable quantization was found beneath
the limit given by nmax or in target_edo (if specified).
}
\description{
This function attempts to take in a sign vector (and associated cardinality
and \code{ineqmat}) and create a scale whose sign vector matches the input.
This is not always possible because not all sign vectors correspond to
colors that actually exist (just like there is no Fortean set class with
the interval-class vector \verb{<1 1 0 1 0 0>}). The function will do its best
but may eventually time out, using a similar process as \code{\link[=quantize_color]{quantize_color()}}.
You can increase the search time by increasing \code{nmax}, but in some cases
you could search forever and still find nothing. I don't advise trying to
use this function on many sign vectors at the same time.
}
\examples{
# This first command produces a real tetrachord:
set_from_signvector(c(-1, 1, 1, -1, -1, -1, 0, -1), 4)

# But this one, which changes only the last entry of the previous sign vector
# has no solution so will return only `NA`s.
set_from_signvector(c(-1, 1, 1, -1, -1, -1, 0, 1), 4)
  
}
