% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vaxrepnum.R
\name{vaxrepnum}
\alias{vaxrepnum}
\title{Calculate reproduction number for a multigroup model with a given state of
vaccination and immunity}
\usage{
vaxrepnum(meaninf, popsize, trmat, initR, initV, vaxeff)
}
\arguments{
\item{meaninf}{mean infectious period with same time units as trmat}

\item{popsize}{the population size of each group}

\item{trmat}{matrix of group-to-group (column-to-row) transmission rates}

\item{initR}{initial number of each group already infected and immune}

\item{initV}{initial number of each group vaccinated}

\item{vaxeff}{effectiveness (0 to 1) of vaccine in producing immunity to infection}
}
\value{
the reproduction number
}
\description{
Calculate reproduction number for a multigroup model with a given state of
vaccination and immunity
}
\examples{
meaninf <- 7
popsize <- c(200, 800)
initR <- c(0, 0)
initV <- c(0, 0)
vaxeff <- 1
trmat <- matrix(c(0.63, 0.31, 0.19, 1.2), 2, 2)
vaxrepnum(meaninf, popsize, trmat, initR, initV, vaxeff)
vaxrepnum(meaninf, popsize, trmat, initR, initV = c(160, 750), vaxeff)
}
