#' Residuals from a fitted model
#'
#' This returns analogs of martingale residuals, as a matrix with one column
#' for each hazard.
#'
#' @param object an object of type multiRec
#' @param ... not used
#' @param type character, the type of residuals. The default is "martingale" for
#' an analog of martingale residuals in coxph. Specifying "score" retrieves a
#' matrix score components (see details).
#'
#' @details
#' This function returns a matrix with one row for each observation (i.e.
#' interval) in the input data= dataset, and one column for each hazard model
#' in the call to multiRec().
#'
#' For each hazard model, the martingale-like residuals are defined as the
#' difference delta.i-cumHaz.i where delta.i is an indicator for whether the
#' corresponding event occurred and cumHaz.i is the estimate of the event specific
#' cumulative hazard.
#'
#' For each hazard model, the score residual is the component of the score
#' vector.
#'
#' @return a numeric matrix with one row per interval and one column per hazard
#' @importFrom stats resid
#' @export
resid.multiRec = function(object, ..., type=c("martingale", "score")) {
  type = match.arg(type)
  if (type=='martingale') return(object$resid)
  else if (type=='score') return(object$score.components)
}
