% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{resist_components}
\alias{resist_components}
\title{Calculates resistance components from a list of pairwise resistance surfaces}
\usage{
resist_components(foldername = foldername, p_val = p_val, cl = NULL)
}
\arguments{
\item{foldername}{A \code{character} this is the location where the
resistance surfaces are stored.}

\item{p_val}{A \code{numeric} this sets the significance threshold for axes
in explaining variance in the original resistance matrix based on redundancy
analysis. In effect this filters out axes that don't explain variance.}

\item{cl}{A parallel argument to be passed to \code{\link[vegan:dbrda]{vegan::capscale()}} if parallel
compute is wanted.}
}
\value{
A data frame.
}
\description{
Calculates resistance components from a list of pairwise resistance surfaces
}
\details{
Outputs a data frame of significant resistance components for each
matrix in the target folder. These data can be combined with non-pairwise
matrix data.
}
\examples{
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
Y <- resist_components(filename = 'FILE_PATH', p_val = 0.01)
\dontshow{\}) # examplesIf}
}
