% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-db.R
\name{create_table}
\alias{create_table}
\title{Create or Append a Table from a Tibble or DBI-Backed Table}
\usage{
create_table(
  .data,
  .con,
  database_name,
  schema_name,
  table_name,
  write_type = "overwrite"
)
}
\arguments{
\item{.data}{Tibble/data frame (in-memory) or a \code{dbplyr}/DBI-backed lazy
table (class \code{"tbl_dbi"}).}

\item{.con}{A valid \code{DBI} connection (DuckDB / MotherDuck).}

\item{database_name}{Database name to create/use.}

\item{schema_name}{Schema name to create/use.}

\item{table_name}{Target table name to create or append to.}

\item{write_type}{Write strategy: \code{"overwrite"} (drop/create) or
\code{"append"} (insert rows). Defaults to \code{"overwrite"}.}
}
\value{
Invisibly returns \code{NULL}. Side effect: writes a table to the database by
delegating to the appropriate helper.
}
\description{
A thin wrapper that routes to either \code{\link[=create_table_dbi]{create_table_dbi()}} (for
\code{dbplyr}-backed lazy tables, class \code{"tbl_dbi"}) or
\code{\link[=create_table_tbl]{create_table_tbl()}} (for in-memory tibbles / data frames), creating
a physical table in the target database/schema. Supports \strong{overwrite}
and \strong{append} write strategies and defers all heavy lifting to the
specific implementation.
}
\details{
\itemize{
\item If \code{.data} is a \code{dbplyr} lazy table (class \code{"tbl_dbi"}), the call is
delegated to \code{\link[=create_table_dbi]{create_table_dbi()}}.
\item If \code{.data} is an in-memory tibble/data frame (class including
\code{"data.frame"}), the call is delegated to \code{\link[=create_table_tbl]{create_table_tbl()}}.
\item Any other input classes trigger an error.
}
}
\seealso{
Other db-manage: 
\code{\link{alter_table_schema}()},
\code{\link{copy_tables_to_new_location}()},
\code{\link{create_database}()},
\code{\link{create_if_not_exists_share}()},
\code{\link{create_or_replace_share}()},
\code{\link{create_schema}()},
\code{\link{delete_and_create_schema}()},
\code{\link{delete_database}()},
\code{\link{delete_schema}()},
\code{\link{delete_table}()},
\code{\link{describe_share}()},
\code{\link{drop_share}()},
\code{\link{list_owned_shares}()},
\code{\link{list_shared_with_me_shares}()},
\code{\link{upload_database_to_md}()}
}
\concept{db-manage}
