% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmt_factory.R
\name{fmt_equivalence}
\alias{fmt_equivalence}
\title{Rounding with number of digits determined by an equivalence test}
\usage{
fmt_equivalence(conf_level = 0.95, digits = 3, pdigits = NULL, ...)
}
\arguments{
\item{conf_level}{Confidence level to use for the equivalence test (1 - alpha).}

\item{digits}{Number of significant digits to keep.}

\item{pdigits}{Number of decimal digits to keep for p values. If \code{NULL}, the value of \code{digits} is used.}

\item{...}{Additional arguments are passed to the \code{format()} function (e.g., \code{big.marks}, \code{scientific}). See \code{?format}}
}
\description{
This function implements the suggestions of Astier & Wolak for the number of decimal digits to keep for coefficient estimates. The other statistics are rounded by \code{fmt_significant()}.
}
\examples{
library(modelsummary)
mod <- lm(mpg ~ hp, mtcars)

# Default equivalence-based formatting
modelsummary(mod, fmt = fmt_equivalence())

# alpha = 0.2
modelsummary(mod, fmt = fmt_equivalence(conf_level = .8))

# default equivalence, but with alternative significant digits for other statistics
modelsummary(mod, fmt = fmt_equivalence(digits = 5))

}
\references{
Astier, Nicolas, and Frank A. Wolak. Credible Numbers: A Procedure for Reporting Statistical Precision in Parameter Estimates. No. w32124. National Bureau of Economic Research, 2024.
}
