% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_task_classif.R
\name{as_task_classif}
\alias{as_task_classif}
\alias{as_task_classif.TaskClassif}
\alias{as_task_classif.data.frame}
\alias{as_task_classif.matrix}
\alias{as_task_classif.DataBackend}
\alias{as_task_classif.TaskRegr}
\alias{as_task_classif.formula}
\title{Convert to a Classification Task}
\usage{
as_task_classif(x, ...)

\method{as_task_classif}{TaskClassif}(x, clone = FALSE, ...)

\method{as_task_classif}{data.frame}(
  x,
  target,
  id = deparse1(substitute(x)),
  positive = NULL,
  label = NA_character_,
  ...
)

\method{as_task_classif}{matrix}(
  x,
  target,
  id = deparse1(substitute(x)),
  label = NA_character_,
  ...
)

\method{as_task_classif}{DataBackend}(
  x,
  target,
  id = deparse1(substitute(x)),
  positive = NULL,
  label = NA_character_,
  ...
)

\method{as_task_classif}{TaskRegr}(
  x,
  target,
  drop_original_target = FALSE,
  drop_levels = TRUE,
  ...
)

\method{as_task_classif}{formula}(
  x,
  data,
  id = deparse1(substitute(data)),
  positive = NULL,
  label = NA_character_,
  ...
)
}
\arguments{
\item{x}{(any)\cr
Object to convert.}

\item{...}{(any)\cr
Additional arguments.}

\item{clone}{(\code{logical(1)})\cr
If \code{TRUE}, ensures that the returned object is not the same as the input \code{x}.}

\item{target}{(\code{character(1)})\cr
Name of the target column.}

\item{id}{(\code{character(1)})\cr
Id for the new task.
Defaults to the (deparsed and substituted) name of the data argument.}

\item{positive}{(\code{character(1)})\cr
Level of the positive class. See \link{TaskClassif}.}

\item{label}{(\code{character(1)})\cr
Label for the new instance.}

\item{drop_original_target}{(\code{logical(1)})\cr
If \code{FALSE} (default), the original target is added as a feature.
Otherwise the original target is dropped.}

\item{drop_levels}{(\code{logical(1)})\cr
If \code{TRUE} (default), unused levels of the new target variable are dropped.}

\item{data}{(\code{data.frame()})\cr
Data frame containing all columns referenced in formula \code{x}.}
}
\value{
\link{TaskClassif}.
}
\description{
Convert object to a \link{TaskClassif}.
This is a S3 generic. mlr3 ships with methods for the following objects:
\enumerate{
\item \link{TaskClassif}: returns the object as-is, possibly cloned.
\item \code{\link{formula}}, \code{\link[=data.frame]{data.frame()}}, \code{\link[=matrix]{matrix()}}, and \link{DataBackend}: provides an alternative to the constructor of \link{TaskClassif}.
\item \link{TaskRegr}: Calls \code{\link[=convert_task]{convert_task()}}.
}

Note that the target column will be converted to a \code{factor()}, if possible.
}
\examples{
as_task_classif(palmerpenguins::penguins, target = "species")
}
