% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute-analysis.R
\name{gsegment}
\alias{gsegment}
\title{Divides track expression into segments}
\usage{
gsegment(
  expr = NULL,
  minsegment = NULL,
  maxpval = 0.05,
  onetailed = TRUE,
  intervals = NULL,
  iterator = NULL,
  intervals.set.out = NULL
)
}
\arguments{
\item{expr}{track expression}

\item{minsegment}{minimal segment size}

\item{maxpval}{maximal P-value that separates two adjacent segments}

\item{onetailed}{if 'TRUE', Wilcoxon test is performed one tailed, otherwise
two tailed}

\item{intervals}{genomic scope for which the function is applied}

\item{iterator}{track expression iterator of "fixed bin" type. If 'NULL'
iterator is determined implicitly based on track expression.}

\item{intervals.set.out}{intervals set name where the function result is
optionally outputted}
}
\value{
If 'intervals.set.out' is 'NULL' a set of intervals where each
interval represents a segment.
}
\description{
Divides the values of track expression into segments by using Wilcoxon test.
}
\details{
This function divides the values of track expression into segments, where
each segment size is at least of 'minsegment' size and the P-value of
comparing the segment with the first 'minsegment' values from the next
segment is at most 'maxpval'. Comparison is done using Wilcoxon (also known
as Mann-Whitney) test.

If 'intervals.set.out' is not 'NULL' the result is saved as an intervals
set. Use this parameter if the result size exceeds the limits of the
physical memory.
}
\examples{
\dontshow{
options(gmax.processes = 2)
}

gdb.init_examples()
gsegment("dense_track", 5000, 0.0001)

}
\seealso{
\code{\link{gscreen}}, \code{\link{gwilcox}}
}
\keyword{~Mann-Whitney}
\keyword{~segment}
\keyword{~wilcoxon}
