% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirai-package.R
\docType{package}
\name{mirai-package}
\alias{mirai-package}
\title{mirai: Minimalist Async Evaluation Framework for R}
\description{
\emph{moving already} \cr \cr
Evaluates R expressions asynchronously and in parallel, locally or
distributed across networks. An official parallel cluster type for R. Built
on 'nanonext' and 'NNG', its non-polling, event-driven architecture scales
from a laptop to thousands of processes across high-performance computing
clusters and cloud platforms. Features FIFO scheduling with task
cancellation, promises for reactive programming, 'OpenTelemetry' distributed
tracing, and custom serialization for cross-language data types.
}
\section{Notes}{


For local mirai requests, the default transport for inter-process
communications is platform-dependent: abstract Unix domain sockets on Linux,
Unix domain sockets on MacOS, Solaris and other POSIX platforms, and named
pipes on Windows.

This may be overridden by specifying 'url' in \code{\link[=daemons]{daemons()}} and launching
daemons using \code{\link[=launch_local]{launch_local()}}.
}

\section{OpenTelemetry}{


mirai provides comprehensive OpenTelemetry tracing support for observing
asynchronous operations and distributed computation. Please refer to the
OpenTelemetry vignette for further details:
\code{vignette("v05-opentelemetry", package = "mirai")}
}

\section{Reference Manual}{


\code{vignette("mirai", package = "mirai")}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://mirai.r-lib.org}
  \item \url{https://github.com/r-lib/mirai}
  \item Report bugs at \url{https://github.com/r-lib/mirai/issues}
}

}
\author{
\strong{Maintainer}: Charlie Gao \email{charlie.gao@posit.co} (\href{https://orcid.org/0000-0002-0750-061X}{ORCID})

Other contributors:
\itemize{
  \item Joe Cheng \email{joe@posit.co} [contributor]
  \item Posit Software, PBC (\href{https://ror.org/03wc8by49}{ROR}) [copyright holder, funder]
  \item Hibiki AI Limited [copyright holder]
}

}
