% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{get_CI}
\alias{get_CI}
\title{Bootstrap-based confidence intervals for MIA}
\usage{
get_CI(
  mia_res,
  n_boot = 1000,
  type = "bca",
  conf = 0.95,
  boot_args = list(),
  boot.ci_args = list(),
  show_progress = TRUE
)
}
\arguments{
\item{mia_res}{Output from the \code{mia} function.}

\item{n_boot}{Numeric scalar specifying the number of bootstrap replicates to use}

\item{type}{Character string specifying the type of confidence interval. The options are \code{"norm"}, \code{"basic"}, \code{"perc"}, and \code{"bca"}.}

\item{conf}{Numeric scalar specifying the level of the confidence interval. The default is \code{0.95}.}

\item{boot_args}{A list of additional arguments to pass to the \code{\link[boot]{boot}} function. Note that this includes parallelization options.}

\item{boot.ci_args}{A list of additional arguments to pass to the \code{\link[boot]{boot.ci}} function}

\item{show_progress}{Logical scalar indicating whether to show a progress bar during bootstrap. Default is \code{TRUE}. The progress bar will not be displayed when parallelization is used.}
}
\value{
An object of class "mia_ci". This object is a list with the following elements:
\item{ci_1}{An object of class "boot.ci" which contains the output of the \code{\link[boot]{boot.ci}} function applied for the confidence interval around the mean under \code{X_values_1} in \code{\link{mia}}.}
\item{ci_2}{An object of class "boot.ci" which contains the output of the \code{\link[boot]{boot.ci}} function applied for the confidence interval around the mean under \code{X_values_2} in \code{\link{mia}} (if applicable).}
\item{ci_contrast}{An object of class "boot.ci" which contains the output of the \code{\link[boot]{boot.ci}} function applied for the confidence interval around the contrast between mean under \code{X_values_1} versus \code{X_values_2} in \code{\link{mia}} (if applicable).}
\item{bres}{An object of class "boot" which contains the output of the \code{\link[boot]{boot}} function. Users can access the bootstrap replicates through the element \code{t} in this object.}
\item{...}{additional elements}
}
\description{
This function applies nonparametric bootstrap to construct confidence intervals around the conditional mean estimates obtained by \code{\link{mia}}. This function is a wrapper for the \code{\link[boot]{boot}} and \code{\link[boot]{boot.ci}} functions from the \pkg{boot} package.
}
\examples{
set.seed(1234)
res <- mia(data = dat.sim,
           X_names = c("X1", "X2"),
           X_values_1 = c(0, 1), X_values_2 = c(0, 0),
           Y_model = Y ~ W + X1 + X2, W_model = W ~ X1 + X2)
res_ci <- get_CI(mia_res = res, n_boot = 50, type = 'perc')
res_ci

## Example with parallelization
res_par <- get_CI(res, n_boot = 100, type = 'perc',
                 boot_args = list(parallel = "snow", ncpus = 2))


}
