% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_spectra}
\alias{plot_spectra}
\title{Plot Spectra}
\usage{
plot_spectra(
  obj,
  ...,
  sfy = 1e+06,
  xlab = "Chemical Shift [ppm]",
  ylab = paste("Signal Intensity [au] /", sfy),
  mar = c(4.1, 4.1, 1.1, 0.1),
  lgd = TRUE
)
}
\arguments{
\item{obj}{An object of type \code{decons0}, \code{decons1} or \code{decons2}. For details see
\href{https://spang-lab.github.io/metabodecon/articles/Classes.html}{Metabodecon Classes}.}

\item{...}{Additional arguments passed to the conversion function.}

\item{sfy}{Scaling factor for the y-axis.}

\item{xlab}{Label for the x-axis.}

\item{ylab}{Label for the y-axis.}

\item{mar}{A numeric vector of length 4, which specifies the margins of the plot.}

\item{lgd}{Logical. If TRUE, a legend is drawn.}
}
\value{
A plot of the deconvoluted spectra.
}
\description{
Plot a set of deconvoluted spectra.
}
\examples{
obj <- deconvolute(sim[1:4], sfr = c(3.55, 3.35))
plot_spectra(obj)
}
\seealso{
\code{\link[=plot_spectrum]{plot_spectrum()}} for a much more sophisticated plotting routine
suitable for plotting a single spectrum.
}
\author{
2024-2025 Tobias Schmidt: initial version.
}
