% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hybridSVR.R
\name{svrHybrid}
\alias{svrHybrid}
\title{SVR with Metaheuristic Algorithms Optimization}
\usage{
svrHybrid(
  x_train,
  y_train,
  x_test,
  y_test,
  kernel = "radial",
  optimizer = "AO",
  objective = "RMSE",
  is.y.normalize = FALSE,
  min.y = min.y,
  max.y = max.y,
  max_iter = 100,
  N = 30,
  seed = 123,
  degree = 3,
  coef0 = 0,
  nu = 0.5,
  class.weights = NULL,
  cachesize = 40,
  tolerance = 0.001,
  scale = TRUE,
  shrinking = TRUE,
  cross = 0,
  probability = FALSE,
  fitted = TRUE,
  subset,
  na.action = na.omit
)
}
\arguments{
\item{x_train}{A matrix or data frame contain predictors variable for training the model.}

\item{y_train}{A numeric vector of target values for training model.}

\item{x_test}{A matrix or data frame contain predictors variable for testing the model. It can be replaced by
data validation to get the parameter if you separated the data as three categories and need more reliable model.}

\item{y_test}{A numeric vector of target values for training model. It can be replaced by
data validation to get the parameter if you separated the data as three categories and need more reliable model.}

\item{kernel}{SVR kernel type used for modelling. Options: "linear", "radial", "polynomial", or "sigmoid". Default is radial.}

\item{optimizer}{Metaheuristic Algorithms selection, options: "AO", "CBO", "AOCBO", "HHO", "GWO", "ALO", or "EHHOCBO". Default is AO.}

\item{objective}{Objective function used for optimization as prediction quality measures. Options: "SMAPE", "MAPE", "RMSE", or "MAE". Default is RMSE.}

\item{is.y.normalize}{Logical; use when prediction of target variable 'y' is on min-max scalling normalization. Default is FALSE. Note: It is only use when the data normalize by normalize() function in this package.}

\item{min.y}{Minimum value of target (used for denormalization). No need to fill this parameter if y is not normalize.}

\item{max.y}{Maximum value of target (used for denormalization). No need to fill this parameter if y is not normalize.}

\item{max_iter}{Maximum number of iterations for the optimizer. Default is 100.}

\item{N}{Population size for the optimizer. Default is 30.}

\item{seed}{Random seed for reproducibility algorithm. Default is 123.}

\item{degree}{Degree parameter for polynomial kernel.Default is 3.}

\item{coef0}{Coefficient parameter used in polynomial/sigmoid kernels.}

\item{nu}{Parameter for 'nu-regression' to controlling max proportion of error training and minimum proportion of support vectors. Default is 0.5, range: 0.1-0.9.
Only use if the type of regression choosen is 'nu-regression'.}

\item{class.weights}{A named list of class weights.}

\item{cachesize}{Size of kernel cache (in MB). Default is 40.}

\item{tolerance}{Tolerance of termination criterion.}

\item{scale}{Logical; whether to scale inputs. Default is TRUE.}

\item{shrinking}{Logical; whether to use shrinking heuristics. Default is TRUE.}

\item{cross}{Number of folds for cross-validation. Default is 0, no cross validation.}

\item{probability}{Logical; whether to enable probability model. Default is FALSE.}

\item{fitted}{Logical; whether to keep fitted values. Default is TRUE.}

\item{subset}{Optional vector specifying subset of observations to be used in the training fit.}

\item{na.action}{Function which indicates what should happen when the data contain NAs.}
}
\value{
A list containing:
\describe{
  \item{best_params}{A list with the best values for `cost`, `gamma`, and `epsilon`.}
  \item{total_iter}{Total number of iterations run by the optimizer.}
  \item{model}{The final trained SVR model (using `e1071::svm`).}
  \item{time}{Total training time in HMS format.}
}
}
\description{
Trains a Support vector Regression Model by optimizing its parameter (Cost, Gamma, and Epsilon)
using Metaheuristic Algorithms such as: Archimedes Optimization (AO), Coot Bird Optimization (CBO),
Combined Archimedes Optimization with Coot Bird Optimization (AOCBO),
Harris Hawks Optimization (HHO), Grey Wolf Optimizer (GWO), Ant Lion Optimization (ALO),
and Enhanced Harris Hawks Optimization with Coot Bird Optimization (EHHOCBO).
}
\examples{
{
set.seed(1)
x <- matrix(rnorm(100), ncol = 2)
y <- x[,1] * 3 + rnorm(50)
model <- svrHybrid(x_train = x[1:40,], y_train = y[1:40],
                   x_test = x[41:50,], y_test = y[41:50],
                   kernel = "radial", optimizer = "AO",
                   objective = "RMSE", is.y.normalize = FALSE)
# To
model$best_params
}

}
