% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractMemoryFeatures.R
\name{extractMemoryFeatures}
\alias{extractMemoryFeatures}
\title{Extracts ecological memory features from the output of \code{\link{computeMemory}}.}
\usage{
extractMemoryFeatures(
  memory.pattern = NULL,
  exogenous.component = NULL,
  endogenous.component = NULL,
  scale.strength = TRUE
)
}
\arguments{
\item{memory.pattern}{either a list resulting from \code{\link{computeMemory}}, or a dataframe with memory patterns of several taxa generated by \code{\link{experimentToTable}}. When using output from \code{\link{experimentToTable}}, filter to a specific sampling resolution before calling this function (e.g., \code{data[data$sampling == 25, ]}). Default: \code{NULL}.}

\item{exogenous.component}{character string or character vector,
name of the variable or variables defining the exogenous component.
When \code{memory.pattern} is output from \code{\link{computeMemory}},
this is automatically extracted from the \code{$drivers} slot if not provided.
Required when input is from \code{\link{experimentToTable}}. Default: \code{NULL}.}

\item{endogenous.component}{character string, name of the variable defining
the endogenous component.
When \code{memory.pattern} is output from \code{\link{computeMemory}},
this is automatically extracted from the \code{$response} slot if not provided.
Required when input is from \code{\link{experimentToTable}}. Default: \code{NULL}.}

\item{scale.strength}{boolean. If \code{TRUE}, the strength of the ecological memory components, which has the same units as the importance scores yielded by random Forest (percentage of increment in mean squared error when a variable is permuted), is scaled between 0 and 1. Default: \code{TRUE}.}
}
\value{
A dataframe with 8 columns and 1 row if \code{memory.pattern} is the output of \code{\link{computeMemory}} and 13 columns and as many rows as taxa are in the input if it is the output of \code{\link{experimentToTable}}. The columns are:

\itemize{
  \item \emph{label} character string to identify the taxon. It either inherits its values from \code{\link{experimentToTable}}, or sets the default ID as "1".
  \item \emph{strength.endogenous} numeric, difference between the maximum importance of the endogenous component at any lag and the median of the random component (see details in \code{\link{computeMemory}}). When \code{scale.strength = TRUE} (default), values are scaled to [0, 1]; otherwise values are in importance units (percentage of increment in MSE).
  \item \emph{strength.exogenous} numeric, same as above, but for the exogenous component.
  \item \emph{strength.concurrent} numeric, same as above, but for the concurrent component (driver at lag 0).
  \item \emph{length.endogenous} numeric in the range [0, 1], proportion of lags over which the importance of the endogenous memory component is above the median of the random component.
  \item \emph{length.exogenous} numeric in the range [0, 1], same as above but for the exogenous memory component.
  \item \emph{dominance.endogenous} numeric in the range [0, 1], proportion of the lags above the median of the random term over which a the endogenous memory component has a higher importance than the exogenous component.
  \item \emph{dominance.exogenous}, opposite as above.
  \item \emph{maximum.age}, numeric. As every column after this one, only provided if \code{memory.pattern} is the output of \code{\link{experimentToTable}}. Trait of the given taxon.
  \item \emph{fecundity} numeric, trait of the given taxon.
  \item \emph{niche.mean} numeric, trait of the given taxon.
  \item \emph{niche.sd} numeric, trait of the given taxon.
}
}
\description{
Computes the following features of the ecological memory patterns returned by \code{\link{computeMemory}}:
\itemize{
   \item \code{memory strength} maximum difference in relative importance between each component (endogenous, exogenous, and concurrent) and the median of the random component. This is computed for exogenous, endogenous, and concurrent effect.
    \item \code{memory length} proportion of lags over which the importance of a memory component is above the median of the random component. This is only computed for endogenous and exogenous memory.
\item \code{dominance} proportion of the lags above the median of the random term over which a memory component has a higher importance than the other component. This is only computed for endogenous and exogenous memory.
}
}
\details{
\strong{Warning:} this function only works when only one exogenous component (driver) is used to define the model in \code{\link{computeMemory}}. If more than one driver is provided through the argument \code{exogenous.component}, the maximum importance scores of all exogenous variables is considered. In other words, the importance of exogenous variables is not additive.
}
\examples{

# Loading example data (output of computeMemory)
data(palaeodataMemory)

# Simplified call - components auto-detected from computeMemory output
memory.features <- extractMemoryFeatures(
  memory.pattern = palaeodataMemory
)

# Explicit call - still supported for backwards compatibility
memory.features <- extractMemoryFeatures(
  memory.pattern = palaeodataMemory,
  exogenous.component = c(
    "climate.temperatureAverage",
    "climate.rainfallAverage"
  ),
  endogenous.component = "pollen.pinus"
)
}
\seealso{
\code{\link{computeMemory}}

Other memoria: 
\code{\link{computeMemory}()},
\code{\link{plotMemory}()}
}
\author{
Blas M. Benito  <blasbenito@gmail.com>
}
\concept{memoria}
