#' Lagged data generated by \code{\link{prepareLaggedData}}.
#'
#' A dataframe resulting from the application of \code{\link{prepareLaggedData}} to the dataset \code{\link{palaeodata}}. The dataframe columns are named using the pattern \code{VariableName__LagValue}:
#'
#' \itemize{
#'   \item \emph{pollen.pinus__0} numeric, values of the response variable (pollen counts of Pinus) at lag 0 (current time). This column is used as the response variable by \code{\link{computeMemory}}.
#'   \item \emph{pollen.pinus__0.2-1} numeric, time-delayed values of the response for lags 0.2 to 1 (in ky). These columns represent the endogenous ecological memory.
#'   \item \emph{climate.temperatureAverage__0} numeric, temperature values at lag 0 (concurrent effect).
#'   \item \emph{climate.rainfallAverage__0} numeric, rainfall values at lag 0 (concurrent effect).
#'   \item \emph{climate.temperatureAverage__0.2-1} numeric, time-delayed temperature values for lags 0.2 to 1 (exogenous memory).
#'   \item \emph{climate.rainfallAverage__0.2-1} numeric, time-delayed rainfall values for lags 0.2 to 1 (exogenous memory).
#'   \item \emph{time} numeric, the time/age column.
#' }
#'
#' The dataframe has attributes \code{response} and \code{drivers} that are automatically used by \code{\link{computeMemory}}.
#'
#' @author Blas M. Benito  <blasbenito@gmail.com>
#' @docType data
#' @keywords datasets
#' @name palaeodataLagged
#' @usage data(palaeodataLagged)
#' @family example_data
#' @format dataframe with 19 columns and 3988 rows.
"palaeodataLagged"


#' Dataframe with pollen counts.
#'
#' A dataframe with the following columns:
#'
#' \itemize{
#'   \item \emph{age} in kiloyears before present (ky BP).
#'   \item \emph{pinus} pollen counts of Pinus.
#'   \item \emph{quercus} pollen counts of Quercus.
#'   \item \emph{poaceae} pollen counts of Poaceae.
#'   \item \emph{artemisia} pollen counts of Artemisia.
#' }
#' @author Blas M. Benito  <blasbenito@gmail.com>
#' @docType data
#' @keywords datasets
#' @name pollen
#' @usage data(pollen)
#' @family example_data
#' @format dataframe with 5 columns and 639 rows.
"pollen"


#' Dataframe with palaeoclimatic data.
#'
#' A dataframe containing palaeoclimate data at 1 ky temporal resolution with the following columns:
#'
#' \itemize{
#'   \item \emph{age} in kiloyears before present (ky BP).
#'   \item \emph{temperatureAverage} average annual temperature in degrees Celsius.
#'   \item \emph{rainfallAverage} average annual precipitation in millimetres per day (mm/day).
#'   \item \emph{temperatureWarmestMonth} average temperature of the warmest month, in degrees Celsius.
#'   \item \emph{temperatureColdestMonth} average temperature of the coldest month, in degrees Celsius.
#'   \item \emph{oxigenIsotope} delta O18, global ratio of stable isotopes in the sea floor, see \url{http://lorraine-lisiecki.com/stack.html} for further details.
#' }
#' @author Blas M. Benito  <blasbenito@gmail.com>
#' @docType data
#' @keywords datasets
#' @name climate
#' @usage data(climate)
#' @family example_data
#' @format dataframe with 6 columns and 800 rows.
"climate"


#' Dataframe with pollen and climate data.
#'
#' A dataframe with a regular time grid of 0.2 ky resolution resulting from applying \code{\link{mergePalaeoData}} to the datasets \code{\link{climate}} and \code{\link{pollen}}:
#'
#' \itemize{
#'   \item \emph{age} in ky before present (ky BP).
#'   \item \emph{pollen.pinus} pollen percentages of Pinus.
#'   \item \emph{pollen.quercus} pollen percentages of Quercus.
#'   \item \emph{pollen.poaceae} pollen percentages of Poaceae.
#'   \item \emph{pollen.artemisia} pollen percentages of Artemisia.
#'   \item \emph{climate.temperatureAverage} average annual temperature in degrees Celsius.
#'   \item \emph{climate.rainfallAverage} average annual precipitation in millimetres per day (mm/day).
#'   \item \emph{climate.temperatureWarmestMonth} average temperature of the warmest month, in degrees Celsius.
#'   \item \emph{climate.temperatureColdestMonth} average temperature of the coldest month, in degrees Celsius.
#'   \item \emph{climate.oxigenIsotope} delta O18, global ratio of stable isotopes in the sea floor, see \url{http://lorraine-lisiecki.com/stack.html} for further details.
#' }
#' @author Blas M. Benito  <blasbenito@gmail.com>
#' @docType data
#' @keywords datasets
#' @name palaeodata
#' @usage data(palaeodata)
#' @family example_data
#' @format dataframe with 10 columns and 7986 rows.
"palaeodata"


#' Output of \code{\link{computeMemory}}
#'
#' List containing the output of \code{\link{computeMemory}} applied to \code{\link{palaeodataLagged}}. Its slots are:
#'
#'  \itemize{
#'  \item \code{response} character, response variable name.
#'  \item \code{drivers} character vector, driver variable names.
#'  \item \code{memory} dataframe with five columns:
#'     \itemize{
#'       \item \code{variable} character, names of the different variables used to model ecological memory.
#'       \item \code{lag} numeric, time lag values.
#'       \item \code{median} numeric, median importance across \code{repetitions} of the given \code{variable} according to Random Forest.
#'       \item \code{sd} numeric, standard deviation of the importance values of the given \code{variable} across \code{repetitions}.
#'       \item \code{min} and \code{max} numeric, percentiles 0.05 and 0.95 of importance values of the given \code{variable} across \code{repetitions}.
#'     }
#'  \item \code{R2} vector, values of pseudo R-squared value obtained for the Random Forest model fitted on each repetition. Pseudo R-squared is the Pearson correlation between the observed and predicted data.
#'  \item \code{prediction} dataframe, with the same columns as the dataframe in the slot \code{memory}, with the median and confidence intervals of the predictions of all random forest models fitted.
#' }
#' @author Blas M. Benito  <blasbenito@gmail.com>
#' @docType data
#' @keywords datasets
#' @name palaeodataMemory
#' @usage data(palaeodataMemory)
#' @family example_data
#' @format List with five slots.
"palaeodataMemory"

#' @import ggplot2 zoo ranger
#' @importFrom grDevices col2rgb hsv rgb2hsv
#' @importFrom rlang .data
#' @importFrom stats as.formula cor filter lag loess loess.control na.omit predict quantile rnorm
NULL

#' @import utils
utils::globalVariables(c(
  "prediction",
  "lag",
  "median",
  "variable",
  "sd",
  "parameters",
  "name",
  # For plotExperiment (uses old column names from runExperiment)
  "Lag",
  "Variable"
))
