% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_charlson_codes.R
\name{get_charlson_codes}
\alias{get_charlson_codes}
\title{Get Charlson Codes}
\usage{
get_charlson_codes()
}
\value{
A \code{data.frame} with the following columns:
\itemize{
\item \code{icdv}: Integer vector indicating if the code is from ICD-9 or ICD-10
\item \code{dx}: Integer vector.  1 if the code is a diagnostic, (ICD-9-CM, ICD-10-CM, WHO, CDC Mortality), or 0 if the code is procedural (ICD-9-PCS, ICD-10-PCS)
\item \code{full_code}: Character vector with the ICD code and any relevant decimal point
\item \code{code}: Character vector with the compact ICD code
\item \code{condition}: Character vector of the conditions
\item \verb{charlson_\\<variant\\>}: Integer vector indicating if the code is part of the \<variant\> of the Charlson comorbidities.
}
}
\description{
Retrieve a copy of internal lookup tables for the ICD codes
used in assessing Charlson comorbidities.
}
\examples{
head(get_charlson_codes())
str(get_charlson_codes())

}
\seealso{
\itemize{
\item \code{\link[=get_charlson_index_scores]{get_charlson_index_scores()}} for a lookup table of the by comorbidity index scores.
\item \code{\link[=get_icd_codes]{get_icd_codes()}} for the lookup table of all ICD codes.
\item \code{\link[=get_pccc_codes]{get_pccc_codes()}} for the lookup table of ICD codes used for the PCCC.
\item \code{\link[=get_elixhauser_codes]{get_elixhauser_codes()}} for the lookup table of ICD codes used for the Elixhauser comorbidities.
\item \code{\link[=comorbidities]{comorbidities()}} for applying comorbidity algorithms to a data set.
}
}
