% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{pr_MLiG}
\alias{pr_MLiG}
\title{Create an object representing a Multivariate Log inverse Gamma (MLiG) prior distribution}
\usage{
pr_MLiG(mean = 0, precision = 0, labels = NULL, a = 1000)
}
\arguments{
\item{mean}{scalar or vector parameter for the mean in the large
\code{a} limit, when the distribution approaches a normal distribution.}

\item{precision}{scalar or vector parameter for the precision in the
large \code{a} limit, when the distribution approaches a normal
distribution.}

\item{labels}{optional character vector with coefficient labels. If specified,
it should have the same length as at least one of \code{mean} and \code{precision},
and in that case the MLiG prior with these parameters is assigned to these coefficients,
while any coefficients not present in labels will be assigned a non-informative
prior with mean 0 and precision 0.}

\item{a}{scalar parameter that controls how close the prior is to independent
normal priors with \code{mean} and \code{precision} parameters. The larger
this value (default is 1000), the closer.}
}
\value{
An environment representing the specified prior, for internal use.
}
\description{
Create an object representing a Multivariate Log inverse Gamma (MLiG) prior distribution
}
\references{
J.R. Bradley, S.H. Holan and C.K. Wikle (2018).
   Computationally efficient multivariate spatio-temporal models for
   high-dimensional count-valued data (with discussion).
   Bayesian Analysis 13(1), 253-310.
}
