% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/G_h.R
\name{G_h}
\alias{G_h}
\title{Global irradiance on Mars horizontal surface}
\usage{
G_h(
  Ls,
  phi,
  longitude,
  Ts = NULL,
  z = Z(Ls = Ls, phi = phi, Ts = Ts),
  tau,
  al = albedo(latitude = phi, longitude = longitude, tau = tau)
)
}
\arguments{
\item{Ls}{Areocentric longitude [deg]}

\item{phi}{Planetary latitude [deg]}

\item{longitude}{Planetary longitude [deg]}

\item{Ts}{Solar time [h]}

\item{z}{Sun zenith angle [deg]. If not provided, calculated from Ls, phi, and Ts}

\item{tau}{Atmospheric optical depth (dimensionless)}

\item{al}{Surface albedo (dimensionless, 0-1). If not provided, calculated from latitude, longitude, and tau}
}
\value{
Global irradiance [W/m²]
}
\description{
Calculates the total solar irradiance (direct beam + diffuse + albedo) incident on a
horizontal surface on Mars. Implements Equation 17 from Appelbaum & Flood (1990).
}
