% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F20.R
\name{F20}
\alias{F20}
\title{Hartmann 6D Function (F20)}
\usage{
F20(x)
}
\arguments{
\item{x}{Numeric vector of length 6 (6-dimensional input).}
}
\value{
Numeric scalar representing the function value.
}
\description{
A multimodal test function with 6 local minima in 6 dimensions.
Fixed dimension of 6.
}
\details{
\strong{Formula:}
\deqn{f(x) = -\sum_{i=1}^{4} c_i \exp\left(-\sum_{j=1}^{6} a_{ij}(x_j - p_{ij})^2\right)}

where \eqn{a_{ij}}, \eqn{c_i}, and \eqn{p_{ij}} are predefined constants.

\strong{Global minimum:}
\eqn{f(0.20169, 0.150011, 0.476874, 0.275332, 0.311652, 0.6573) \approx -3.32237}

\strong{Characteristics:}
\itemize{
  \item Type: Multimodal
  \item Separable: No
  \item Differentiable: Yes
  \item Fixed dimension: 6
  \item Number of local minima: 6
  \item Default bounds: \eqn{[0, 1]^6}
}

The Hartmann 6D function is more challenging than the 3D version due to
the higher dimensionality.
}
\examples{
F20(c(0.20169, 0.150011, 0.476874, 0.275332, 0.311652, 0.6573))
# Returns approximately -3.32237

}
\seealso{
\code{\link{test-functions}} for an overview of all test functions,
\code{\link{get_function_details}} to retrieve function parameters,
\code{\link{F19}} for the 3D version.
}
