% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjrr.R
\name{confint.margin}
\alias{confint.margin}
\title{Confidence interval for marginal effect}
\usage{
\method{confint}{margin}(object, parm, level = 0.95, ...)
}
\arguments{
\item{object}{An object of class "`margin`" resulting from a call to margin}

\item{parm}{No effect.}

\item{level}{the confidence level required}

\item{...}{additional argument(s) for methods}
}
\value{
A named vector giving lower and upper confidence limits for the marginal effect. They
will be labelled as (1-level)/2 and 1-(1-level).2 An argument df can be provided to use a t-test
to construct the confidence interval.
}
\description{
Confidence interval method for class "`margin`"
}
\details{
Computes confidence intervals using a standard Wald test for the marginal effect. If argument
`df` is used, then a t-statistic is use to construct the interval with `df` degrees of freedom,
otherwise a z-statistic is used.
}
\examples{
## fit a model using glmmTMB
fit <- glmmTMB::glmmTMB(y ~ Treatment + x1 + x2 + x3 + x4 + (1|Cluster),
  data = trial_data, family = binomial(link="logit"),REML = TRUE)
## relative risk, average over random effects and fixed effects
m1 <- margin(fit,
       x = "Treatment",
       type = "ratio",
       average = c("x1","x2","x3","x4"),
       re = "average",
       se="GLS")
confint(m1)
}
